/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;

public class BindingIOUtil {
    public static void saveBinding(DataOutputStream dos, IBinding binding, int version) throws DataException {
        int type = binding.getDataType();
        String name = binding.getBindingName();
        String function = binding.getAggrFunction();
        IBaseExpression expr = binding.getExpression();
        IBaseExpression filter = binding.getFilter();
        List arguments = binding.getArguments();
        List aggregateOn = binding.getAggregatOns();
        ITimeFunction timeFunction = binding.getTimeFunction();
        try {
            IOUtil.writeInt(dos, type);
            IOUtil.writeString(dos, name);
            IOUtil.writeString(dos, function);
            ExprUtil.saveBaseExpr(dos, expr);
            ExprUtil.saveBaseExpr(dos, filter);
            IOUtil.writeInt(dos, arguments.size());
            int i = 0;
            while (i < arguments.size()) {
                ExprUtil.saveBaseExpr(dos, (IBaseExpression)arguments.get(i));
                ++i;
            }
            IOUtil.writeInt(dos, aggregateOn.size());
            i = 0;
            while (i < aggregateOn.size()) {
                IOUtil.writeString(dos, aggregateOn.get(i).toString());
                ++i;
            }
            if (version >= 180) {
                if (timeFunction != null) {
                    IOUtil.writeBool(dos, true);
                    IOUtil.writeString(dos, timeFunction.getTimeDimension());
                    IOUtil.writeObject(dos, timeFunction.getReferenceDate().getDate());
                    ITimePeriod baseTimePeriod = timeFunction.getBaseTimePeriod();
                    ITimePeriod relativeTimePeriod = timeFunction.getRelativeTimePeriod();
                    if (baseTimePeriod != null) {
                        IOUtil.writeBool(dos, true);
                        IOUtil.writeString(dos, baseTimePeriod.getType().toString());
                        IOUtil.writeInt(dos, baseTimePeriod.countOfUnit());
                        IOUtil.writeBool(dos, baseTimePeriod.isCurrent());
                    } else {
                        IOUtil.writeBool(dos, false);
                    }
                    if (relativeTimePeriod != null) {
                        IOUtil.writeBool(dos, true);
                        IOUtil.writeObject(dos, relativeTimePeriod.getType().toString());
                        IOUtil.writeInt(dos, relativeTimePeriod.countOfUnit());
                    } else {
                        IOUtil.writeBool(dos, false);
                    }
                } else {
                    IOUtil.writeBool(dos, false);
                }
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public static IBinding loadBinding(DataInputStream dis, int version) throws IOException, DataException {
        boolean hasTimeFunction;
        int type = IOUtil.readInt(dis);
        String name = IOUtil.readString(dis);
        String function = IOUtil.readString(dis);
        IBaseExpression expr = ExprUtil.loadBaseExpr(dis);
        IBaseExpression filter = ExprUtil.loadBaseExpr(dis);
        Binding binding = new Binding(name);
        binding.setAggrFunction(function);
        binding.setDataType(type);
        binding.setExpression(expr);
        binding.setFilter(filter);
        int argSize = IOUtil.readInt(dis);
        int i = 0;
        while (i < argSize) {
            binding.addArgument(ExprUtil.loadBaseExpr(dis));
            ++i;
        }
        int aggrSize = IOUtil.readInt(dis);
        int i2 = 0;
        while (i2 < aggrSize) {
            binding.addAggregateOn(IOUtil.readString(dis));
            ++i2;
        }
        if (version >= 180 && (hasTimeFunction = IOUtil.readBool(dis))) {
            String timeDimensionName = IOUtil.readString(dis);
            TimeFunction time = new TimeFunction();
            if (timeDimensionName != null) {
                boolean containsRelativePeriod;
                time.setTimeDimension(timeDimensionName);
                Date referenceDate = (Date)IOUtil.readObject(dis);
                time.setReferenceDate(new ReferenceDate(referenceDate));
                boolean containsBasePeriod = IOUtil.readBool(dis);
                if (containsBasePeriod) {
                    TimePeriodType periodType = BindingIOUtil.getPeriodType(IOUtil.readString(dis));
                    int unit = IOUtil.readInt(dis);
                    boolean isCurrent = IOUtil.readBool(dis);
                    TimePeriod basedTimePeriod = new TimePeriod(unit, periodType, isCurrent);
                    time.setBaseTimePeriod(basedTimePeriod);
                }
                if (containsRelativePeriod = IOUtil.readBool(dis)) {
                    TimePeriodType periodType = BindingIOUtil.getPeriodType(IOUtil.readString(dis));
                    int unit = IOUtil.readInt(dis);
                    TimePeriod relativeTimePeriod = new TimePeriod(unit, periodType);
                    time.setRelativeTimePeriod(relativeTimePeriod);
                }
            }
            binding.setTimeFunction(time);
        }
        return binding;
    }

    private static TimePeriodType getPeriodType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(TimePeriodType.YEAR.toString())) {
            return TimePeriodType.YEAR;
        }
        if (type.equals(TimePeriodType.QUARTER.toString())) {
            return TimePeriodType.QUARTER;
        }
        if (type.equals(TimePeriodType.MONTH.toString())) {
            return TimePeriodType.MONTH;
        }
        if (type.equals(TimePeriodType.WEEK.toString())) {
            return TimePeriodType.WEEK;
        }
        if (type.equals(TimePeriodType.DAY.toString())) {
            return TimePeriodType.DAY;
        }
        return null;
    }
}

