/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.ImmutableMap;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import java.util.Map;
import java.util.TreeMap;

public class GenericFormatReferentialSpeciesImportResult
extends GenericFormatReferentialImportResult<Species, Integer> {
    private static final long serialVersionUID = 1L;
    private ImmutableMap<Integer, Integer> referenceTaxonIdTranslationMap = ImmutableMap.of();

    public GenericFormatReferentialSpeciesImportResult(String filename, boolean found) {
        super(filename, found);
    }

    public Map<Integer, Integer> getReferenceTaxonIdTranslationMap() {
        return this.referenceTaxonIdTranslationMap;
    }

    public void flushObsoleteReferenceTaxonIds(Map<Integer, Integer> referenceTaxonIdById) {
        this.referenceTaxonIdTranslationMap = ImmutableMap.copyOf(referenceTaxonIdById);
    }

    public void flushReferenceTaxonIds(Map<Integer, Integer> referenceTaxonIdById) {
        TreeMap<Integer, Integer> referenceTaxonIdMap = new TreeMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : referenceTaxonIdById.entrySet()) {
            Integer oldId = entry.getKey();
            String originalId = String.valueOf(oldId);
            Species species = (Species)this.entitiesAdded.get(originalId);
            if (species == null) {
                species = (Species)this.entitiesLinked.get(originalId);
            }
            Integer oldReferenceTaxonId = entry.getValue();
            Integer newReferenceTaxonId = species.getReferenceTaxonId();
            referenceTaxonIdMap.put(oldReferenceTaxonId, newReferenceTaxonId);
        }
        this.referenceTaxonIdTranslationMap = ImmutableMap.builder().putAll(this.referenceTaxonIdTranslationMap).putAll(referenceTaxonIdMap).build();
    }
}

