/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.tree;

import com.google.common.collect.Iterators;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.CruiseSelectTreeNode;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeNodeSupport;
import java.util.HashSet;
import java.util.Iterator;

public class ProgramSelectTreeNode
extends DataSelectTreeNodeSupport<ProgramDataModel>
implements Iterable<CruiseSelectTreeNode> {
    private static final long serialVersionUID = 1L;

    public ProgramSelectTreeNode(ProgramDataModel userObject) {
        super(userObject);
        for (CruiseDataModel cruise : userObject) {
            CruiseSelectTreeNode cruiseNode = new CruiseSelectTreeNode(cruise);
            this.add(cruiseNode);
        }
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public ProgramDataModel getSelectedDataModel() {
        HashSet<CruiseDataModel> cruises = new HashSet<CruiseDataModel>();
        for (CruiseSelectTreeNode o : this) {
            CruiseDataModel cruise = o.getSelectedDataModel();
            if (cruise == null) continue;
            cruises.add(cruise);
        }
        ProgramDataModel result = new ProgramDataModel(this.getId(), this.getLabel(), cruises);
        return result;
    }

    @Override
    public Iterator<CruiseSelectTreeNode> iterator() {
        return Iterators.forEnumeration(this.children());
    }

    public boolean isSelectedDataExists() {
        boolean result = false;
        for (CruiseSelectTreeNode cruise : this) {
            if (!cruise.isSelectedDataExists()) continue;
            result = true;
            break;
        }
        return result;
    }
}

