/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRowBean;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.protocol.CaracteristicRow;
import fr.ifremer.tutti.service.protocol.CaracteristicRowModel;
import fr.ifremer.tutti.service.protocol.SpeciesRow;
import fr.ifremer.tutti.service.protocol.SpeciesRowModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ext.CsvReaders;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ProtocolImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ProtocolImportExportService.class);

    public void exportProtocol(TuttiProtocol protocol, File file) {
        TuttiProtocols.toFile((TuttiProtocol)protocol, (File)file);
    }

    public TuttiProtocol importProtocol(File file) {
        return TuttiProtocols.fromFile((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProtocolCaracteristic(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol caracteristic from file: " + file));
        }
        TreeMultimap ids = TreeMultimap.create();
        CaracteristicRowModel csvModel = new CaracteristicRowModel(this.getCsvSeparator(), caracteristicMap);
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (CaracteristicRow bean : importer) {
                    CaracteristicType caracteristicType = bean.getPmfmType();
                    Caracteristic caracteristic = bean.getPmfm();
                    String id = caracteristic.getId();
                    ids.put((Object)caracteristicType, (Object)id);
                }
                importer.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImportRuntimeException("Could not import protocol [" + protocol.getName() + "] caracteristic from file " + file, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        protocol.setLengthClassesPmfmId(this.mergeIds(protocol.getLengthClassesPmfmId(), ids.get((Object)CaracteristicType.LENGTH_STEP)));
        protocol.setIndividualObservationPmfmId(this.mergeIds(protocol.getIndividualObservationPmfmId(), ids.get((Object)CaracteristicType.INDIVIDUAL_OBSERVATION)));
        ArrayList caracteristicMapping = protocol.getCaracteristicMapping();
        if (caracteristicMapping == null) {
            caracteristicMapping = new ArrayList();
        }
        HashMap<String, CaracteristicMappingRow> rowsByCaracteristicId = new HashMap<String, CaracteristicMappingRow>((Map<String, CaracteristicMappingRow>)Maps.uniqueIndex(caracteristicMapping, (Function)new Function<CaracteristicMappingRow, String>(){

            public String apply(CaracteristicMappingRow caracteristicMappingRow) {
                return caracteristicMappingRow.getPmfmId();
            }
        }));
        this.mergeCaracteristicMappingRows((Multimap<CaracteristicType, String>)ids, rowsByCaracteristicId, CaracteristicType.GEAR_USE_FEATURE);
        this.mergeCaracteristicMappingRows((Multimap<CaracteristicType, String>)ids, rowsByCaracteristicId, CaracteristicType.VESSEL_USE_FEATURE);
        protocol.setCaracteristicMapping(new ArrayList(rowsByCaracteristicId.values()));
    }

    public void exportAllCaracteristic(File file, Map<String, Caracteristic> caracteristicMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristics to file: " + file));
        }
        PmfmIdToCaracteristicRowFunction function = new PmfmIdToCaracteristicRowFunction(caracteristicMap);
        List rows = Lists.transform((List)Lists.newArrayList(caracteristicMap.keySet()), (Function)function);
        CaracteristicRowModel csvModel = new CaracteristicRowModel(this.getCsvSeparator(), caracteristicMap);
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ImportRuntimeException(I18n.t((String)"tutti.service.protocol.export.caracteristics.all.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportProtocolCaracteristic(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristics to file: " + file));
        }
        PmfmIdToCaracteristicRowFunction function = new PmfmIdToCaracteristicRowFunction(caracteristicMap);
        ArrayList rows = Lists.newArrayList();
        if (!protocol.isLengthClassesPmfmIdEmpty()) {
            function.setType(CaracteristicType.LENGTH_STEP);
            rows.addAll(Lists.transform((List)protocol.getLengthClassesPmfmId(), (Function)function));
        }
        if (!protocol.isCaracteristicMappingEmpty()) {
            for (CaracteristicMappingRow mappingRow : protocol.getCaracteristicMapping()) {
                function.setType(CaracteristicType.valueOf((String)mappingRow.getTab()));
                rows.add(function.apply(mappingRow.getPmfmId()));
            }
        }
        if (!protocol.isIndividualObservationPmfmIdEmpty()) {
            function.setType(CaracteristicType.INDIVIDUAL_OBSERVATION);
            rows.addAll(Lists.transform((List)protocol.getIndividualObservationPmfmId(), (Function)function));
        }
        CaracteristicRowModel csvModel = new CaracteristicRowModel(this.getCsvSeparator(), caracteristicMap);
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.caracteristics.protocol.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Species> importProtocolSpecies(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol [" + protocol.getName() + "] species from file: " + file));
        }
        ArrayList<Species> result = new ArrayList<Species>();
        LinkedHashMap ids = Maps.newLinkedHashMap();
        if (!protocol.isSpeciesEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                ids.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        LinkedHashMap benthosIds = Maps.newLinkedHashMap();
        if (!protocol.isBenthosEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                benthosIds.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        SpeciesRowModel csvModel = SpeciesRowModel.forImport(this.getCsvSeparator(), caracteristicMap, speciesMap);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            Serializable serializable = null;
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                Binder binder = BinderFactory.newBinder(SpeciesRow.class, SpeciesProtocol.class);
                for (SpeciesRow bean : importer) {
                    Species species = bean.getSpecies();
                    Integer id = species.getReferenceTaxonId();
                    SpeciesProtocol sp = (SpeciesProtocol)benthosIds.get(id);
                    if (sp != null) {
                        result.add(species);
                        continue;
                    }
                    sp = (SpeciesProtocol)ids.get(id);
                    if (sp == null) {
                        sp = SpeciesProtocols.newSpeciesProtocol();
                    }
                    binder.copy((Object)bean, (Object)sp, new String[0]);
                    sp.setMandatorySampleCategoryId((List)Lists.newArrayList(bean.getMandatorySampleCategoryId()));
                    this.cleanRptData(sp);
                    ids.put(id, sp);
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            ArrayList values = Lists.newArrayList(ids.values());
            protocol.setSpecies((List)values);
            serializable = result;
            return serializable;
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.import.species.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
    }

    public List<Species> importProtocolBenthos(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol [" + protocol.getName() + "] species from file: " + file));
        }
        ArrayList<Species> result = new ArrayList<Species>();
        LinkedHashMap ids = Maps.newLinkedHashMap();
        if (!protocol.isBenthosEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                ids.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        LinkedHashMap speciesIds = Maps.newLinkedHashMap();
        if (!protocol.isSpeciesEmpty()) {
            for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                speciesIds.put(speciesProtocol.getSpeciesReferenceTaxonId(), speciesProtocol);
            }
        }
        SpeciesRowModel csvModel = SpeciesRowModel.forImport(this.getCsvSeparator(), caracteristicMap, speciesMap);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
             Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
            Binder binder = BinderFactory.newBinder(SpeciesRow.class, SpeciesProtocol.class);
            for (SpeciesRow bean : importer) {
                Species species = bean.getSpecies();
                Integer id = species.getReferenceTaxonId();
                SpeciesProtocol sp = (SpeciesProtocol)speciesIds.get(id);
                if (sp != null) {
                    result.add(species);
                    continue;
                }
                sp = (SpeciesProtocol)ids.get(id);
                if (sp == null) {
                    sp = SpeciesProtocols.newSpeciesProtocol();
                }
                binder.copy((Object)bean, (Object)sp, new String[0]);
                this.cleanRptData(sp);
                ids.put(id, sp);
            }
            ArrayList values = Lists.newArrayList(ids.values());
            protocol.setBenthos((List)values);
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.import.benthos.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
        return result;
    }

    public List<String> loadProtocolCaracteristicsImportColumns(File columnsFile) throws IOException {
        String[] headers = CsvReaders.getHeader((File)columnsFile, (char)';');
        ArrayList<String> result = new ArrayList<String>(headers.length);
        for (String header : headers) {
            if (header.startsWith("\"") && header.endsWith("\"") || header.startsWith("'") && header.endsWith("'")) {
                header = header.substring(1, header.length() - 1);
            }
            result.add(header);
        }
        Collections.sort(result);
        return result;
    }

    public void exportProtocolSpecies(File file, List<SpeciesProtocol> protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export species to file: " + file));
        }
        List rows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(protocol)) {
            rows = Lists.transform(protocol, (Function)new SpeciesProtocolToSpeciesRowFunction(caracteristicMap, speciesMap));
        }
        SpeciesRowModel csvModel = SpeciesRowModel.forExport(this.getCsvSeparator());
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public void exportProtocolBenthos(File file, List<SpeciesProtocol> protocol, Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export benthos to file: " + file));
        }
        List rows = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(protocol)) {
            rows = Lists.transform(protocol, (Function)new SpeciesProtocolToSpeciesRowFunction(caracteristicMap, speciesMap));
        }
        SpeciesRowModel csvModel = SpeciesRowModel.forExport(this.getCsvSeparator());
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.benthos.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }

    protected List<String> mergeIds(Collection<String> fromProtocol, Collection<String> fromImport) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(fromProtocol)) {
            for (String s : fromProtocol) {
                if (result.contains(s)) continue;
                result.add(s);
            }
        }
        for (String s : fromImport) {
            if (result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    protected void mergeCaracteristicMappingRows(Multimap<CaracteristicType, String> ids, Map<String, CaracteristicMappingRow> rowsByCaracteristicId, CaracteristicType type) {
        for (String id : ids.get((Object)type)) {
            CaracteristicMappingRow row = rowsByCaracteristicId.get(id);
            if (row == null) {
                row = new CaracteristicMappingRowBean();
                row.setPmfmId(id);
                rowsByCaracteristicId.put(id, row);
            }
            row.setTab(type.name());
        }
    }

    protected void cleanRptData(SpeciesProtocol sp) {
        Rtp rtpUndefined;
        Rtp rtpFemale;
        Rtp rtpMale;
        if (sp.withRtpMale() && (rtpMale = sp.getRtpMale()).getA() == null && rtpMale.getB() == null) {
            sp.setRtpMale(null);
        }
        if (sp.withRtpFemale() && (rtpFemale = sp.getRtpFemale()).getA() == null && rtpFemale.getB() == null) {
            sp.setRtpFemale(null);
        }
        if (sp.withRtpUndefined() && (rtpUndefined = sp.getRtpUndefined()).getA() == null && rtpUndefined.getB() == null) {
            sp.setRtpUndefined(null);
        }
    }

    private static class SpeciesProtocolToSpeciesRowFunction
    implements Function<SpeciesProtocol, SpeciesRow> {
        private final Map<String, Species> speciesMap;
        private final Map<String, Caracteristic> caracteristicMap;
        private final Binder<SpeciesProtocol, SpeciesRow> binder;

        public SpeciesProtocolToSpeciesRowFunction(Map<String, Caracteristic> caracteristicMap, Map<String, Species> speciesMap) {
            this.speciesMap = speciesMap;
            this.caracteristicMap = caracteristicMap;
            this.binder = BinderFactory.newBinder(SpeciesProtocol.class, SpeciesRow.class);
        }

        public SpeciesRow apply(SpeciesProtocol input) {
            Species species = this.speciesMap.get(String.valueOf(input.getSpeciesReferenceTaxonId()));
            Preconditions.checkNotNull((Object)species, (Object)("Could not find a species with id: " + input));
            SpeciesRow result = new SpeciesRow();
            this.binder.copy((Object)input, (Object)result, new String[0]);
            String pmfmId = input.getLengthStepPmfmId();
            if (pmfmId != null) {
                Caracteristic caracteristic = this.caracteristicMap.get(pmfmId);
                result.setLengthStepPmfm(caracteristic);
            }
            result.setSpecies(species);
            result.setMandatorySampleCategoryId(Lists.newArrayList((Iterable)input.getMandatorySampleCategoryId()));
            return result;
        }
    }

    private static class PmfmIdToCaracteristicRowFunction
    implements Function<String, CaracteristicRow> {
        private CaracteristicType type;
        private final Map<String, Caracteristic> caracteristicMap;

        public PmfmIdToCaracteristicRowFunction(Map<String, Caracteristic> caracteristicMap) {
            this.caracteristicMap = caracteristicMap;
        }

        public CaracteristicRow apply(String input) {
            Caracteristic caracteristic = this.caracteristicMap.get(input);
            Preconditions.checkNotNull((Object)caracteristic, (Object)("Could not find a caracteristic with id: " + input));
            CaracteristicRow result = new CaracteristicRow();
            result.setPmfm(caracteristic);
            result.setPmfmType(this.type);
            return result;
        }

        public void setType(CaracteristicType type) {
            this.type = type;
        }
    }
}

