/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import fr.ifremer.tutti.service.TuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.ZipUtil;

public abstract class AbstractTuttiService
implements TuttiService {
    protected TuttiServiceContext context;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        this.context = context;
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        return this.context.getService(serviceType);
    }

    @Override
    public void close() throws IOException {
    }

    protected void compressZipFile(File zipFile, File directory) {
        try {
            FileUtils.forceMkdir((File)zipFile.getParentFile());
            try {
                ZipUtil.compress((File)zipFile, (File)directory);
            }
            finally {
                FileUtils.deleteDirectory((File)directory);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.compressZipFile.error", (Object[])new Object[]{directory, zipFile}), (Throwable)e);
        }
    }
}

