// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Les méthodes sont rassemblées dans une liste qui couvre tous les domaines pour lesquels il existe
 * un paramètre.
 * La liste des méthodes est générique et porte sur toutes les phases du processus de mesure des
 * paramètres. Chaque méthode n'est pas non plus systématiquement spécifique à l'une de ces phases
 * ou à une nature particulière de paramètre. En effet, une méthode peut couvrir tout le cycle du
 * processus et/ou être utilisable pour une phase quelle que soit la nature du paramètre.
 * Les méthodes peuvent être référencées par les paramètres à différentes phases de leur processus
 * de mesure que sont :
 * pour les paramètres biologique :
 * - le prélèvement et l'échantillonnage ;
 * - la conservation et le transport ;
 * - le fractionnement ;
 * - l'analyse ;
 * pour les paramètres environnementaux :
 * - l'observation ;
 * @see Method
 */
public interface MethodDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link Method}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of Method from the persistent store.
     * @param id
     * @return Method
     */
    public Method get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of Method from the persistent store.
     * @param id
     * @return Method
     */
    public Method load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link Method}.
     *
     * @return the loaded entities.
     */
    public Collection<Method> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of Method and adds it to the persistent store.
     * @param method
     * @return Method
     */
    public Method create(Method method);

    /**
     * <p>
     * Does the same thing as {@link #create(Method)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param method
     * @return Object
     */
    public Object create(int transform, Method method);

    /**
     * Creates a new instance of Method and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of Method
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<Method> create(Collection<Method> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(Method)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<Method> entities);

    /**
     * <p>
     * Creates a new <code>Method</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param name Description courte de la méthode.
     * @param description Description longue de la méthode.
     * @param conditioning Description du conditionnement des échantillons ou des prélèvements en vue de leur analyse.
     * @param preparation Description de la préparation des échantillons ou des prélèvements en vue de leur analyse.
     * @param conservation Description de la méthode de conservation des échantillons ou des prélèvements en vue de leur
analyse.
     * @param reference Référence nationale ou internationale de la méthode.
Référence à l'origine de la méthode.
Par exemple :
- "Bradford M., 1976. A rapid method for quantification of protein utilizing the principle of dye
binding. Anal. Biochem. 72 : 248-264"
- "Circulaire 1988 Mer/Agriculture"
Nombre de lignes : 500
     * @param rank Numéro de la méthode pour pouvoir "chainer" les méthodes. Il est saisi par l'administrateur.
     * @param handbookPath Lien vers un fichier PDF décrivant plus précisemment la méthode.
     * @param creationDate Date système de création de la méthode. Cette date est renseignée automatiquement.
     * @param updateDate Date de mise à jour de création de la méthode. Cette date est renseignée automatiquement.
     * @return Method
     */
    public Method create(
        String name,
        String description,
        String conditioning,
        String preparation,
        String conservation,
        String reference,
        String rank,
        String handbookPath,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Does the same thing as {@link #create(String, String, String, String, String, String, String, String, Date, Timestamp)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param name Description courte de la méthode.
     * @param description Description longue de la méthode.
     * @param conditioning Description du conditionnement des échantillons ou des prélèvements en vue de leur analyse.
     * @param preparation Description de la préparation des échantillons ou des prélèvements en vue de leur analyse.
     * @param conservation Description de la méthode de conservation des échantillons ou des prélèvements en vue de leur
analyse.
     * @param reference Référence nationale ou internationale de la méthode.
Référence à l'origine de la méthode.
Par exemple :
- "Bradford M., 1976. A rapid method for quantification of protein utilizing the principle of dye
binding. Anal. Biochem. 72 : 248-264"
- "Circulaire 1988 Mer/Agriculture"
Nombre de lignes : 500
     * @param rank Numéro de la méthode pour pouvoir "chainer" les méthodes. Il est saisi par l'administrateur.
     * @param handbookPath Lien vers un fichier PDF décrivant plus précisemment la méthode.
     * @param creationDate Date système de création de la méthode. Cette date est renseignée automatiquement.
     * @param updateDate Date de mise à jour de création de la méthode. Cette date est renseignée automatiquement.
     * @return Method
     */
    public Object create(
        int transform,
        String name,
        String description,
        String conditioning,
        String preparation,
        String conservation,
        String reference,
        String rank,
        String handbookPath,
        Date creationDate,
        Timestamp updateDate);

    /**
     * <p>
     * Creates a new <code>Method</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param creationDate
     * @param name
     * @param rank
     * @param status
     * @return Method
     */
    public Method create(
        Date creationDate,
        String name,
        String rank,
        Status status);

    /**
     * <p>
     * Does the same thing as {@link #create(String, String, Date)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param creationDate
     * @param name
     * @param rank
     * @param status
     * @return Object
     */
    public Object create(
        int transform,
        Date creationDate,
        String name,
        String rank,
        Status status);

    /**
     * Updates the <code>method</code> instance in the persistent store.
     * @param method
     */
    public void update(Method method);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<Method> entities);

    /**
     * Removes the instance of Method from the persistent store.
     * @param method
     */
    public void remove(Method method);

    /**
     * Removes the instance of Method having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<Method> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<Method> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.referential.pmfm.MethodDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.referential.pmfm.MethodDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final Method entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,Method)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.referential.pmfm.MethodDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,Method)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}