/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;

public class PageSequenceParse {
    public static List parsePageSequence(String pageRange, long totalPage) throws EngineException {
        ArrayList<long[]> list = new ArrayList<long[]>();
        if (pageRange == null || "".equals(pageRange) || pageRange.toUpperCase().indexOf("ALL") >= 0) {
            list.add(new long[]{1L, totalPage});
            return list;
        }
        String[] ps = pageRange.split(",");
        int i = 0;
        while (i < ps.length) {
            block8: {
                try {
                    if (ps[i].indexOf("-") > 0) {
                        String[] psi = ps[i].split("-");
                        if (psi.length == 2) {
                            long start = Long.parseLong(psi[0].trim());
                            long end = Long.parseLong(psi[1].trim());
                            if (start > 0L && end <= totalPage && end >= start) {
                                list.add(new long[]{Math.max(start, 1L), Math.min(end, totalPage)});
                                break block8;
                            }
                            throw new EngineException("Error.PageNumberRangeError", ps[i]);
                        }
                        throw new EngineException("Error.PageNumberRangeError", ps[i]);
                    }
                    long number = Long.parseLong(ps[i].trim());
                    if (number > 0L && number <= totalPage) {
                        list.add(new long[]{number, number});
                        break block8;
                    }
                    throw new EngineException("Error.PageNumberRangeError", ps[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new EngineException("Error.PageNumberRangeError", ps[i]);
                }
            }
            ++i;
        }
        return PageSequenceParse.sort(list);
    }

    private static List sort(List list) {
        int i = 0;
        while (i < list.size()) {
            long[] currentI = (long[])list.get(i);
            int minIndex = i;
            long[] min = currentI;
            int j = i + 1;
            while (j < list.size()) {
                long[] currentJ = (long[])list.get(j);
                if (currentJ[0] < min[0]) {
                    minIndex = j;
                    min = currentJ;
                }
                ++j;
            }
            if (minIndex != i) {
                list.set(i, min);
                list.set(minIndex, currentI);
            }
            ++i;
        }
        long[] current = null;
        long[] last = null;
        ArrayList<long[]> ret = new ArrayList<long[]>();
        int i2 = 0;
        while (i2 < list.size()) {
            block7: {
                block8: {
                    block6: {
                        current = (long[])list.get(i2);
                        if (last == null) break block6;
                        if (current[1] <= last[1]) break block7;
                        if (current[0] <= last[1]) {
                            current[0] = last[1];
                        }
                        ret.add(current);
                        break block8;
                    }
                    ret.add(current);
                }
                last = current;
            }
            ++i2;
        }
        return ret;
    }
}

