/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise.tree;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.ui.swing.content.cruise.tree.MessageTreeNode;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class CruiseTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;

    public CruiseTreeNode(Cruise cruise, NuitonValidatorResult validationResult) {
        super(cruise);
        this.setAllowsChildren(true);
        this.createChildren(validationResult);
    }

    @Override
    public Cruise getUserObject() {
        return (Cruise)super.getUserObject();
    }

    public void createChildren(NuitonValidatorResult validationResult) {
        boolean withMessage = false;
        if (validationResult.hasFatalMessages()) {
            this.addMessages(NuitonValidatorScope.FATAL, validationResult.getMessagesForScope(NuitonValidatorScope.FATAL));
            withMessage = true;
        }
        if (validationResult.hasErrorMessagess()) {
            this.addMessages(NuitonValidatorScope.ERROR, validationResult.getMessagesForScope(NuitonValidatorScope.ERROR));
            withMessage = true;
        }
        if (validationResult.hasWarningMessages()) {
            this.addMessages(NuitonValidatorScope.WARNING, validationResult.getMessagesForScope(NuitonValidatorScope.WARNING));
            withMessage = true;
        }
        if (!withMessage) {
            this.addMessages(NuitonValidatorScope.INFO, Lists.newArrayList((Object[])new String[]{I18n.t((String)"tutti.validator.info.cruise.noError", (Object[])new Object[0])}));
        }
    }

    protected void addMessages(NuitonValidatorScope scope, List<String> messages) {
        HashSet messageSet = Sets.newHashSet(messages);
        for (String message : messageSet) {
            MessageTreeNode child = new MessageTreeNode(scope, message);
            this.add(child);
        }
    }
}

