/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Date;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertStatement;

public class LoadUpdateDataChange
extends LoadDataChange {
    private String primaryKey;

    public SqlStatement[] generateStatements(Database database) {
        return super.generateStatements(database);
    }

    public LoadUpdateDataChange() {
        super("loadUpdateData", "Smart Load Data");
    }

    public void setPrimaryKey(String primaryKey) throws LiquibaseException {
        if (primaryKey == null) {
            throw new LiquibaseException("primaryKey cannot be null.");
        }
        this.primaryKey = primaryKey;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    protected InsertStatement createStatement(String schemaName, String tableName) {
        return new InsertOrUpdateStatement(schemaName, tableName, this.primaryKey);
    }

    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] forward;
        ArrayList<DeleteStatement> statements = new ArrayList<DeleteStatement>();
        for (SqlStatement thisForward : forward = this.generateStatements(database)) {
            InsertOrUpdateStatement thisInsert = (InsertOrUpdateStatement)thisForward;
            DeleteStatement delete = new DeleteStatement(this.getSchemaName(), this.getTableName());
            delete.setWhereClause(this.getWhereClause(thisInsert, database));
            statements.add(delete);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private String getWhereClause(InsertOrUpdateStatement insertOrUpdateStatement, Database database) {
        String[] pkColumns;
        StringBuffer where = new StringBuffer();
        for (String thisPkColumn : pkColumns = insertOrUpdateStatement.getPrimaryKey().split(",")) {
            where.append(database.escapeColumnName(insertOrUpdateStatement.getSchemaName(), insertOrUpdateStatement.getTableName(), thisPkColumn) + " = ");
            Object newValue = insertOrUpdateStatement.getColumnValues().get(thisPkColumn);
            if (newValue == null || newValue.toString().equals("NULL")) {
                where.append("NULL");
            } else if (newValue instanceof String && database.shouldQuoteValue((String)newValue)) {
                where.append("'").append(database.escapeStringForDatabase((String)newValue)).append("'");
            } else if (newValue instanceof Date) {
                where.append(database.getDateLiteral((Date)newValue));
            } else if (newValue instanceof Boolean) {
                if (((Boolean)newValue).booleanValue()) {
                    where.append(TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getTrueBooleanValue());
                } else {
                    where.append(TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue());
                }
            } else {
                where.append(newValue);
            }
            where.append(" AND ");
        }
        where.delete(where.lastIndexOf(" AND "), where.lastIndexOf(" AND ") + " AND ".length());
        return where.toString();
    }
}

