/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.swing.config.model.CategoryModel;
import jaxx.runtime.swing.config.model.OptionModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.converter.ConverterUtil;

public class ConfigTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] columnClass = new Class[]{String.class, Object.class, String.class};
    protected final CategoryModel categoryModel;

    public ConfigTableModel(CategoryModel categoryModel) {
        this.categoryModel = categoryModel;
        this.categoryModel.addPropertyChangeListener("reload", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ConfigTableModel.this.fireTableDataChanged();
            }
        });
    }

    public CategoryModel getCategoryModel() {
        return this.categoryModel;
    }

    public OptionModel getEntry(int rowIndex) {
        return this.categoryModel.getEntries().get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.categoryModel.getEntries().size();
    }

    @Override
    public int getColumnCount() {
        return columnClass.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnClass[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 && !this.getEntry(rowIndex).isFinal();
    }

    @Override
    public Object getValueAt(int row, int column) {
        OptionModel key = this.getEntry(row);
        Object value = null;
        switch (column) {
            case 0: {
                value = key.getShortLabel();
                if (!StringUtils.isBlank((CharSequence)((String)value))) break;
                value = key.getKey();
                break;
            }
            case 1: {
                value = key.getValue();
                break;
            }
            case 2: {
                value = key.getDefaultValue();
                if (value == null) break;
                value = ConverterUtil.convert(key.getType(), (Object)value);
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object val;
        if (column != 1) {
            throw new IllegalArgumentException("can not edit column " + column);
        }
        OptionModel key = this.getEntry(row);
        if (aValue == null || key.getType().equals(aValue.getClass())) {
            val = aValue;
        } else {
            String valStr = String.valueOf(aValue).trim();
            try {
                val = ConverterUtil.convert(key.getType(), (Object)valStr);
                if (val != null && val instanceof Integer && new Integer(0).equals(val) && !valStr.equals("0")) {
                    val = null;
                }
            }
            catch (Exception e) {
                val = null;
            }
        }
        this.categoryModel.setValue(key, val);
        this.fireTableRowsUpdated(row, row);
    }

    public void destroy() {
        if (this.categoryModel != null) {
            this.categoryModel.destroy();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }
}

