/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.generic.OperationExportRow;
import java.util.List;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.decorator.Decorator;

public class OperationExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<OperationExportRow> {
    public OperationExportModel(char separator, Decorator<Vessel> vesselDecorator) {
        super(separator);
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newNullableColumnForExport("Engin", "gear.name");
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_VALUE_FORMATTER);
        this.newColumnForExport("DateDeb_Op", "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatDeb", "gearShootingStartLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongDeb", "gearShootingStartLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("DateFin_Op", "gearShootingEndDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatFin", "gearShootingEndLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongFin", "gearShootingEndLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Duree", "duration");
        this.newColumnForExport("Strate", "strata", "name", "NA");
        this.newColumnForExport("Sous-Strate", "subStrata", "name", "NA");
        this.newColumnForExport("Localite", "location", "name", "NA");
        this.newColumnForExport("Validite_OP", "fishingOperationValid", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Rectiligne", "fishingOperationRectiligne", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Distance", "trawlDistance", (ValueFormatter)TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newColumnForExport("Saisisseur", "recorderPerson", TuttiCsvUtil.LIST_PERSON_FORMATTER);
        this.newColumnForExport("NavireAssocie", "secondaryVessel", TuttiCsvUtil.newListVesselFormatter(vesselDecorator));
        this.newColumnForExport("Commentaire", "comment");
        this.newNullableColumnForExport("Poids_Total", "catchTotalWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Calcule", "catchTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Vrac", "catchTotalSortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Vrac_Calcule", "catchTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_HorsVrac", "catchTotalUnsortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_HorsVrac_Calcule", "catchTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Non_Trie", "catchTotalRejectedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Non_Trie_Calcule", "catchTotalRejectedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Tremis", "catchTotalSortedTremisWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Tremis_Calcule", "catchTotalSortedTremisWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Carroussel", "catchTotalSortedCarousselWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Carroussel_Calcule", "catchTotalSortedCarousselWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece", "speciesTotalWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Calcule", "speciesTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac", "speciesTotalSortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Calcule", "speciesTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie", "speciesTotalSampleSortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie_Calcule", "speciesTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac", "speciesTotalUnsortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac_Calcule", "speciesTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie", "speciesTotalInertWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie_Calcule", "speciesTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie", "speciesTotalLivingNotItemizedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie_Calcule", "speciesTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos", "benthosTotalWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Calcule", "benthosTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac", "benthosTotalSortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Calcule", "benthosTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie", "benthosTotalSampleSortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie_Calcule", "benthosTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac", "benthosTotalUnsortedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac_Calcule", "benthosTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie", "benthosTotalInertWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie_Calcule", "benthosTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie", "benthosTotalLivingNotItemizedWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie_Calcule", "benthosTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet", "marineLitterTotalWeight", TuttiCsvUtil.FLOAT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet_Calcule", "marineLitterTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
    }

    public void prepareRows(List<OperationExportRow> rows, Cruise cruise, FishingOperation operation, CatchBatch catchBatch) {
        OperationExportRow row = new OperationExportRow();
        row.setCruise(cruise);
        row.setFishingOperation(operation);
        row.setCatchBatch(catchBatch);
        rows.add(row);
    }
}

