/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.history;

import fr.ifremer.adagio.core.dao.data.history.DeletedItemHistory;
import fr.ifremer.adagio.core.dao.data.history.InsertedItemHistory;
import fr.ifremer.adagio.core.dao.data.history.ProcessingHistoryImpl;
import fr.ifremer.adagio.core.dao.data.history.UpdatedItemHistory;
import fr.ifremer.adagio.core.dao.referential.ProcessingStatus;
import fr.ifremer.adagio.core.dao.referential.ProcessingType;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class ProcessingHistory
implements Serializable {
    private static final long serialVersionUID = 2818722309737972976L;
    private Integer id;
    private String name;
    private Date processingDate;
    private String dataTransfertType;
    private Date dataTransfertDate;
    private String dataTransfertAddress;
    private String configuration;
    private String xmlConfiguration;
    private Timestamp updateDate;
    private ProcessingStatus processingStatus;
    private ProcessingType processingType;
    private Collection<UpdatedItemHistory> updatedItemHistories = new HashSet<UpdatedItemHistory>();
    private Collection<InsertedItemHistory> insertedItemHistories = new HashSet<InsertedItemHistory>();
    private Collection<DeletedItemHistory> deletedItemHistories = new HashSet<DeletedItemHistory>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getProcessingDate() {
        return this.processingDate;
    }

    public void setProcessingDate(Date processingDate) {
        this.processingDate = processingDate;
    }

    public String getDataTransfertType() {
        return this.dataTransfertType;
    }

    public void setDataTransfertType(String dataTransfertType) {
        this.dataTransfertType = dataTransfertType;
    }

    public Date getDataTransfertDate() {
        return this.dataTransfertDate;
    }

    public void setDataTransfertDate(Date dataTransfertDate) {
        this.dataTransfertDate = dataTransfertDate;
    }

    public String getDataTransfertAddress() {
        return this.dataTransfertAddress;
    }

    public void setDataTransfertAddress(String dataTransfertAddress) {
        this.dataTransfertAddress = dataTransfertAddress;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getXmlConfiguration() {
        return this.xmlConfiguration;
    }

    public void setXmlConfiguration(String xmlConfiguration) {
        this.xmlConfiguration = xmlConfiguration;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public ProcessingStatus getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(ProcessingStatus processingStatus) {
        this.processingStatus = processingStatus;
    }

    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType = processingType;
    }

    public Collection<UpdatedItemHistory> getUpdatedItemHistories() {
        return this.updatedItemHistories;
    }

    public void setUpdatedItemHistories(Collection<UpdatedItemHistory> updatedItemHistories) {
        this.updatedItemHistories = updatedItemHistories;
    }

    public Collection<InsertedItemHistory> getInsertedItemHistories() {
        return this.insertedItemHistories;
    }

    public void setInsertedItemHistories(Collection<InsertedItemHistory> insertedItemHistories) {
        this.insertedItemHistories = insertedItemHistories;
    }

    public Collection<DeletedItemHistory> getDeletedItemHistories() {
        return this.deletedItemHistories;
    }

    public void setDeletedItemHistories(Collection<DeletedItemHistory> deletedItemHistories) {
        this.deletedItemHistories = deletedItemHistories;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProcessingHistory)) {
            return false;
        }
        ProcessingHistory that = (ProcessingHistory)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static ProcessingHistory newInstance() {
            ProcessingHistoryImpl entity = new ProcessingHistoryImpl();
            return entity;
        }

        public static ProcessingHistory newInstance(String name, Date processingDate, ProcessingStatus processingStatus, ProcessingType processingType) {
            ProcessingHistory entity = Factory.newInstance();
            entity.setName(name);
            entity.setProcessingDate(processingDate);
            entity.setProcessingStatus(processingStatus);
            entity.setProcessingType(processingType);
            return entity;
        }

        public static ProcessingHistory newInstance(String name, Date processingDate, String dataTransfertType, Date dataTransfertDate, String dataTransfertAddress, String configuration, String xmlConfiguration, Timestamp updateDate, ProcessingStatus processingStatus, ProcessingType processingType, Collection<UpdatedItemHistory> updatedItemHistories, Collection<InsertedItemHistory> insertedItemHistories, Collection<DeletedItemHistory> deletedItemHistories) {
            ProcessingHistory entity = Factory.newInstance();
            entity.setName(name);
            entity.setProcessingDate(processingDate);
            entity.setDataTransfertType(dataTransfertType);
            entity.setDataTransfertDate(dataTransfertDate);
            entity.setDataTransfertAddress(dataTransfertAddress);
            entity.setConfiguration(configuration);
            entity.setXmlConfiguration(xmlConfiguration);
            entity.setUpdateDate(updateDate);
            entity.setProcessingStatus(processingStatus);
            entity.setProcessingType(processingType);
            entity.setUpdatedItemHistories(updatedItemHistories);
            entity.setInsertedItemHistories(insertedItemHistories);
            entity.setDeletedItemHistories(deletedItemHistories);
            return entity;
        }
    }
}

