/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AggregateObject;
import org.eclipse.birt.data.engine.expression.ExpressionInfo;
import org.eclipse.birt.data.engine.expression.MultiPassExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

public class ExpressionProcessor
implements IExpressionProcessor {
    private List availableAggrList;
    private DataSetRuntime dataset;
    private ResultSetPopulator rsPopulator;
    private boolean isDataSetMode = true;
    private IResultIterator resultIterator;
    private BaseQuery baseQuery;
    private MultiPassExpressionCompiler currentHelper;

    public ExpressionProcessor(DataSetRuntime dataSet) {
        this.dataset = dataSet;
        this.availableAggrList = new ArrayList();
    }

    @Override
    public void evaluateMultiPassExprOnCmp(IComputedColumnsState iccState, boolean useResultSetMeta) throws DataException {
        assert (iccState != null);
        int exprType = 0;
        int currentGroupLevel = 0;
        MultiPassExpressionCompiler helper = this.getMultiPassCompilerHelper();
        helper.setDataSetMode(this.isDataSetMode);
        int i = 0;
        while (i < iccState.getCount()) {
            if (iccState.isValueAvailable(i)) {
                helper.addAvailableCmpColumn(iccState.getName(i));
            }
            ++i;
        }
        i = 0;
        while (i < iccState.getCount()) {
            if (!iccState.isValueAvailable(i)) {
                IBaseExpression baseExpression = iccState.getExpression(i);
                String name = iccState.getName(i);
                if (useResultSetMeta && name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E")) {
                    exprType = 2;
                    currentGroupLevel = this.getCurrentGroupLevel(name, currentGroupLevel, this.rsPopulator.getQuery());
                    iccState.setValueAvailable(i);
                }
                this.setHandle(this.rsPopulator.getSession().getEngineContext().getScriptContext(), exprType, currentGroupLevel, helper, baseExpression, useResultSetMeta);
                if (exprType == 2) {
                    return;
                }
                if (helper.getExpressionPassLevel() <= 1) {
                    iccState.setValueAvailable(i);
                }
                helper.reSetPassLevelFlag();
            }
            ++i;
        }
        this.calculate(helper);
    }

    private void setHandle(ScriptContext context, int exprType, int currentGroupLevel, MultiPassExpressionCompiler helper, IBaseExpression baseExpression, boolean useResultSetMeta) throws DataException {
        if (baseExpression == null) {
            return;
        }
        if (baseExpression instanceof IScriptExpression) {
            ExpressionInfo exprInfo = new ExpressionInfo((IScriptExpression)baseExpression, exprType, currentGroupLevel, useResultSetMeta);
            baseExpression.setHandle(helper.compileExpression(exprInfo, context));
        } else if (baseExpression instanceof IConditionalExpression) {
            this.compileConditionalExpression((IConditionalExpression)baseExpression, helper, this.rsPopulator, exprType, currentGroupLevel, context);
        } else if (baseExpression instanceof IExpressionCollection) {
            Object[] exprs = ((IExpressionCollection)baseExpression).getExpressions().toArray();
            int i = 0;
            while (i < exprs.length) {
                this.setHandle(context, exprType, currentGroupLevel, helper, (IBaseExpression)exprs[i], useResultSetMeta);
                ++i;
            }
        }
    }

    @Override
    public void evaluateMultiPassExprOnGroup(Object[] exprArray, int[] currentGroupLevel, int arrayType) throws DataException {
        assert (exprArray != null);
        IBaseExpression baseExpression = null;
        MultiPassExpressionCompiler helper = this.getMultiPassCompilerHelper();
        helper.setDataSetMode(this.isDataSetMode);
        int i = 0;
        while (i < exprArray.length) {
            baseExpression = (IBaseExpression)exprArray[i];
            this.setHandle(this.rsPopulator.getSession().getEngineContext().getScriptContext(), arrayType, currentGroupLevel[i], helper, baseExpression, true);
            ++i;
        }
        this.calculate(helper);
    }

    @Override
    public boolean hasAggregateExpr(List list) throws DataException {
        boolean hasAggregate = false;
        MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availableAggrList, this.dataset.getSession().getEngineContext().getScriptContext());
        helper.setDataSetMode(this.isDataSetMode);
        IBaseExpression baseExpression = null;
        int i = 0;
        while (i < list.size()) {
            baseExpression = (IBaseExpression)list.get(i);
            this.compileBaseExpression(baseExpression, helper, this.rsPopulator.getSession().getEngineContext().getScriptContext());
            ++i;
        }
        hasAggregate = helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    @Override
    public boolean hasAggregation(IBaseExpression expression) {
        boolean hasAggregate = false;
        try {
            MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, null, null, this.dataset.getSession().getEngineContext().getScriptContext());
            helper.setDataSetMode(this.isDataSetMode);
            IBaseExpression baseExpression = expression;
            this.compileBaseExpression(baseExpression, helper, this.dataset.getSession().getEngineContext().getScriptContext());
            hasAggregate = helper.getAggregateStatus();
            this.clear();
        }
        catch (DataException dataException) {
            this.clear();
            return false;
        }
        return hasAggregate;
    }

    private void calculate(MultiPassExpressionCompiler helper) throws DataException {
        List aggrList = helper.getAggregateList(1);
        AggregateTable table = helper.getAggregateTable();
        if (aggrList == null || table == null) {
            return;
        }
        if (helper.hasNestedAggregate()) {
            table.calculate(this.resultIterator, this.dataset.getScriptScope(), this.dataset.getSession().getEngineContext().getScriptContext(), (JSAggrValueObject)this.dataset.getJSTempAggrValueObject());
        } else {
            table.calculate(this.resultIterator, this.dataset.getScriptScope(), this.dataset.getSession().getEngineContext().getScriptContext());
        }
        Scriptable aggrObj = table.getJSAggrValueObject();
        this.dataset.setJSTempAggrValueObject(aggrObj);
        int i = 0;
        while (i < aggrList.size()) {
            AggregateObject obj = (AggregateObject)aggrList.get(i);
            obj.setAvailable(true);
            if (this.availableAggrList == null) {
                this.availableAggrList = new ArrayList();
            }
            if (!this.availableAggrList.contains(obj)) {
                this.availableAggrList.add(obj);
            }
            ++i;
        }
    }

    private void compileConditionalExpression(IConditionalExpression baseExpression, MultiPassExpressionCompiler helper, ResultSetPopulator rsPopulator, int exprType, int currentGroupLevel, ScriptContext context) throws DataException {
        IConditionalExpression condition = baseExpression;
        IScriptExpression op = condition.getExpression();
        IBaseExpression op1 = condition.getOperand1();
        IBaseExpression op2 = condition.getOperand2();
        this.setHandle(context, exprType, currentGroupLevel, helper, op, true);
        this.setHandle(context, exprType, currentGroupLevel, helper, op1, true);
        this.setHandle(context, exprType, currentGroupLevel, helper, op2, true);
    }

    private void compileBaseExpression(IBaseExpression baseExpression, MultiPassExpressionCompiler helper, ScriptContext context) throws DataException {
        if (baseExpression instanceof IConditionalExpression) {
            IConditionalExpression condition = (IConditionalExpression)baseExpression;
            IScriptExpression op = condition.getExpression();
            IBaseExpression op1 = condition.getOperand1();
            IBaseExpression op2 = condition.getOperand2();
            if (op != null) {
                helper.compileExpression(op, context);
            }
            if (op1 != null) {
                this.compileBaseExpression(op1, helper, context);
            }
            if (op2 != null) {
                this.compileBaseExpression(op2, helper, context);
            }
        } else if (baseExpression instanceof IScriptExpression) {
            IScriptExpression scriptExpr = (IScriptExpression)baseExpression;
            helper.compileExpression(scriptExpr, context);
        } else if (baseExpression instanceof IExpressionCollection) {
            IExpressionCollection combinedExpr = (IExpressionCollection)baseExpression;
            Object[] exprs = combinedExpr.getExpressions().toArray();
            int i = 0;
            while (i < exprs.length) {
                this.compileBaseExpression((IBaseExpression)exprs[i], helper, context);
                ++i;
            }
        }
    }

    private int getCurrentGroupLevel(String groupText, int start, BaseQuery query) {
        assert (groupText != null);
        assert (query != null);
        IQuery.GroupSpec[] groups = query.getGrouping();
        int i = start;
        while (i < groups.length) {
            IQuery.GroupSpec group = groups[i];
            if (groupText.equals(group.getName()) || groupText.equals(group.getKeyColumn())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private MultiPassExpressionCompiler getMultiPassCompilerHelper() throws DataException {
        if (this.currentHelper == null) {
            this.currentHelper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availableAggrList, this.dataset.getSession().getEngineContext().getScriptContext());
        } else {
            this.currentHelper.setCompilerStatus(this.availableAggrList);
        }
        return this.currentHelper;
    }

    @Override
    public Scriptable getScope() throws DataException {
        return this.dataset.getScriptScope();
    }

    @Override
    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
    }

    @Override
    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
    }

    @Override
    public void setQuery(BaseQuery query) {
        this.baseQuery = query;
    }

    @Override
    public void setResultIterator(IResultIterator resultIterator) {
        this.resultIterator = resultIterator;
        this.dataset.setResultSet(this.resultIterator, false);
    }

    @Override
    public void clear() {
        if (this.availableAggrList != null) {
            this.availableAggrList.clear();
        }
        this.availableAggrList = null;
    }
}

