/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec;

import com.lowagie.text.BadElementException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

public class BmpImage {
    private InputStream inputStream;
    private long bitmapFileSize;
    private long bitmapOffset;
    private long compression;
    private long imageSize;
    private byte[] palette;
    private int imageType;
    private int numBands;
    private boolean isBottomUp;
    private int bitsPerPixel;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    public HashMap properties = new HashMap();
    private long xPelsPerMeter;
    private long yPelsPerMeter;
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private static final int LCS_CALIBRATED_RGB = 0;
    private static final int LCS_sRGB = 1;
    private static final int LCS_CMYK = 2;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    int width;
    int height;

    BmpImage(InputStream inputStream, boolean bl, int n) throws IOException {
        this.bitmapFileSize = n;
        this.bitmapOffset = 0L;
        this.process(inputStream, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Image image = BmpImage.getImage(inputStream);
            image.setUrl(uRL);
            Image image2 = image;
            return image2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Image getImage(InputStream inputStream) throws IOException {
        return BmpImage.getImage(inputStream, false, 0);
    }

    public static Image getImage(InputStream inputStream, boolean bl, int n) throws IOException {
        BmpImage bmpImage = new BmpImage(inputStream, bl, n);
        try {
            Image image = bmpImage.getImage();
            image.setDpi((int)((double)bmpImage.xPelsPerMeter * 0.0254 + 0.5), (int)((double)bmpImage.yPelsPerMeter * 0.0254 + 0.5));
            image.setOriginalType(4);
            return image;
        }
        catch (BadElementException badElementException) {
            throw new ExceptionConverter(badElementException);
        }
    }

    public static Image getImage(String string) throws IOException {
        return BmpImage.getImage(Utilities.toURL(string));
    }

    public static Image getImage(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Image image = BmpImage.getImage(byteArrayInputStream);
        image.setOriginalData(byArray);
        return image;
    }

    protected void process(InputStream inputStream, boolean bl) throws IOException {
        int n;
        int n2;
        block87: {
            long l;
            long l2;
            block88: {
                block86: {
                    this.inputStream = bl || inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
                    if (!bl) {
                        if (this.readUnsignedByte(this.inputStream) != 66 || this.readUnsignedByte(this.inputStream) != 77) {
                            throw new RuntimeException("Invalid magic value for BMP file.");
                        }
                        this.bitmapFileSize = this.readDWord(this.inputStream);
                        this.readWord(this.inputStream);
                        this.readWord(this.inputStream);
                        this.bitmapOffset = this.readDWord(this.inputStream);
                    }
                    if ((l2 = this.readDWord(this.inputStream)) == 12L) {
                        this.width = this.readWord(this.inputStream);
                        this.height = this.readWord(this.inputStream);
                    } else {
                        this.width = this.readLong(this.inputStream);
                        this.height = this.readLong(this.inputStream);
                    }
                    int n3 = this.readWord(this.inputStream);
                    this.bitsPerPixel = this.readWord(this.inputStream);
                    this.properties.put("color_planes", new Integer(n3));
                    this.properties.put("bits_per_pixel", new Integer(this.bitsPerPixel));
                    this.numBands = 3;
                    if (this.bitmapOffset == 0L) {
                        this.bitmapOffset = l2;
                    }
                    if (l2 != 12L) break block86;
                    this.properties.put("bmp_version", "BMP v. 2.x");
                    if (this.bitsPerPixel == 1) {
                        this.imageType = 0;
                    } else if (this.bitsPerPixel == 4) {
                        this.imageType = 1;
                    } else if (this.bitsPerPixel == 8) {
                        this.imageType = 2;
                    } else if (this.bitsPerPixel == 24) {
                        this.imageType = 3;
                    }
                    int n4 = (int)((this.bitmapOffset - 14L - l2) / 3L);
                    int n5 = n4 * 3;
                    if (this.bitmapOffset == l2) {
                        switch (this.imageType) {
                            case 0: {
                                n5 = 6;
                                break;
                            }
                            case 1: {
                                n5 = 48;
                                break;
                            }
                            case 2: {
                                n5 = 768;
                                break;
                            }
                            case 3: {
                                n5 = 0;
                            }
                        }
                        this.bitmapOffset = l2 + (long)n5;
                    }
                    this.readPalette(n5);
                    break block87;
                }
                this.compression = this.readDWord(this.inputStream);
                this.imageSize = this.readDWord(this.inputStream);
                this.xPelsPerMeter = this.readLong(this.inputStream);
                this.yPelsPerMeter = this.readLong(this.inputStream);
                l = this.readDWord(this.inputStream);
                long l3 = this.readDWord(this.inputStream);
                switch ((int)this.compression) {
                    case 0: {
                        this.properties.put("compression", "BI_RGB");
                        break;
                    }
                    case 1: {
                        this.properties.put("compression", "BI_RLE8");
                        break;
                    }
                    case 2: {
                        this.properties.put("compression", "BI_RLE4");
                        break;
                    }
                    case 3: {
                        this.properties.put("compression", "BI_BITFIELDS");
                    }
                }
                this.properties.put("x_pixels_per_meter", new Long(this.xPelsPerMeter));
                this.properties.put("y_pixels_per_meter", new Long(this.yPelsPerMeter));
                this.properties.put("colors_used", new Long(l));
                this.properties.put("colors_important", new Long(l3));
                if (l2 != 40L) break block88;
                switch ((int)this.compression) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (this.bitsPerPixel == 1) {
                            this.imageType = 4;
                        } else if (this.bitsPerPixel == 4) {
                            this.imageType = 5;
                        } else if (this.bitsPerPixel == 8) {
                            this.imageType = 6;
                        } else if (this.bitsPerPixel == 24) {
                            this.imageType = 7;
                        } else if (this.bitsPerPixel == 16) {
                            this.imageType = 8;
                            this.redMask = 31744;
                            this.greenMask = 992;
                            this.blueMask = 31;
                            this.properties.put("red_mask", new Integer(this.redMask));
                            this.properties.put("green_mask", new Integer(this.greenMask));
                            this.properties.put("blue_mask", new Integer(this.blueMask));
                        } else if (this.bitsPerPixel == 32) {
                            this.imageType = 9;
                            this.redMask = 0xFF0000;
                            this.greenMask = 65280;
                            this.blueMask = 255;
                            this.properties.put("red_mask", new Integer(this.redMask));
                            this.properties.put("green_mask", new Integer(this.greenMask));
                            this.properties.put("blue_mask", new Integer(this.blueMask));
                        }
                        n2 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                        n = n2 * 4;
                        if (this.bitmapOffset == l2) {
                            switch (this.imageType) {
                                case 4: {
                                    n = (int)(l == 0L ? 2L : l) * 4;
                                    break;
                                }
                                case 5: {
                                    n = (int)(l == 0L ? 16L : l) * 4;
                                    break;
                                }
                                case 6: {
                                    n = (int)(l == 0L ? 256L : l) * 4;
                                    break;
                                }
                                default: {
                                    n = 0;
                                }
                            }
                            this.bitmapOffset = l2 + (long)n;
                        }
                        this.readPalette(n);
                        this.properties.put("bmp_version", "BMP v. 3.x");
                        break block87;
                    }
                    case 3: {
                        if (this.bitsPerPixel == 16) {
                            this.imageType = 8;
                        } else if (this.bitsPerPixel == 32) {
                            this.imageType = 9;
                        }
                        this.redMask = (int)this.readDWord(this.inputStream);
                        this.greenMask = (int)this.readDWord(this.inputStream);
                        this.blueMask = (int)this.readDWord(this.inputStream);
                        this.properties.put("red_mask", new Integer(this.redMask));
                        this.properties.put("green_mask", new Integer(this.greenMask));
                        this.properties.put("blue_mask", new Integer(this.blueMask));
                        if (l != 0L) {
                            n = (int)l * 4;
                            this.readPalette(n);
                        }
                        this.properties.put("bmp_version", "BMP v. 3.x NT");
                        break block87;
                    }
                    default: {
                        throw new RuntimeException("Invalid compression specified in BMP file.");
                    }
                }
            }
            if (l2 == 108L) {
                this.properties.put("bmp_version", "BMP v. 4.x");
                this.redMask = (int)this.readDWord(this.inputStream);
                this.greenMask = (int)this.readDWord(this.inputStream);
                this.blueMask = (int)this.readDWord(this.inputStream);
                this.alphaMask = (int)this.readDWord(this.inputStream);
                long l4 = this.readDWord(this.inputStream);
                int n6 = this.readLong(this.inputStream);
                int n7 = this.readLong(this.inputStream);
                int n8 = this.readLong(this.inputStream);
                int n9 = this.readLong(this.inputStream);
                int n10 = this.readLong(this.inputStream);
                int n11 = this.readLong(this.inputStream);
                int n12 = this.readLong(this.inputStream);
                int n13 = this.readLong(this.inputStream);
                int n14 = this.readLong(this.inputStream);
                long l5 = this.readDWord(this.inputStream);
                long l6 = this.readDWord(this.inputStream);
                long l7 = this.readDWord(this.inputStream);
                if (this.bitsPerPixel == 1) {
                    this.imageType = 10;
                } else if (this.bitsPerPixel == 4) {
                    this.imageType = 11;
                } else if (this.bitsPerPixel == 8) {
                    this.imageType = 12;
                } else if (this.bitsPerPixel == 16) {
                    this.imageType = 13;
                    if ((int)this.compression == 0) {
                        this.redMask = 31744;
                        this.greenMask = 992;
                        this.blueMask = 31;
                    }
                } else if (this.bitsPerPixel == 24) {
                    this.imageType = 14;
                } else if (this.bitsPerPixel == 32) {
                    this.imageType = 15;
                    if ((int)this.compression == 0) {
                        this.redMask = 0xFF0000;
                        this.greenMask = 65280;
                        this.blueMask = 255;
                    }
                }
                this.properties.put("red_mask", new Integer(this.redMask));
                this.properties.put("green_mask", new Integer(this.greenMask));
                this.properties.put("blue_mask", new Integer(this.blueMask));
                this.properties.put("alpha_mask", new Integer(this.alphaMask));
                int n15 = (int)((this.bitmapOffset - 14L - l2) / 4L);
                int n16 = n15 * 4;
                if (this.bitmapOffset == l2) {
                    switch (this.imageType) {
                        case 10: {
                            n16 = (int)(l == 0L ? 2L : l) * 4;
                            break;
                        }
                        case 11: {
                            n16 = (int)(l == 0L ? 16L : l) * 4;
                            break;
                        }
                        case 12: {
                            n16 = (int)(l == 0L ? 256L : l) * 4;
                            break;
                        }
                        default: {
                            n16 = 0;
                        }
                    }
                    this.bitmapOffset = l2 + (long)n16;
                }
                this.readPalette(n16);
                switch ((int)l4) {
                    case 0: {
                        this.properties.put("color_space", "LCS_CALIBRATED_RGB");
                        this.properties.put("redX", new Integer(n6));
                        this.properties.put("redY", new Integer(n7));
                        this.properties.put("redZ", new Integer(n8));
                        this.properties.put("greenX", new Integer(n9));
                        this.properties.put("greenY", new Integer(n10));
                        this.properties.put("greenZ", new Integer(n11));
                        this.properties.put("blueX", new Integer(n12));
                        this.properties.put("blueY", new Integer(n13));
                        this.properties.put("blueZ", new Integer(n14));
                        this.properties.put("gamma_red", new Long(l5));
                        this.properties.put("gamma_green", new Long(l6));
                        this.properties.put("gamma_blue", new Long(l7));
                        throw new RuntimeException("Not implemented yet.");
                    }
                    case 1: {
                        this.properties.put("color_space", "LCS_sRGB");
                        break;
                    }
                    case 2: {
                        this.properties.put("color_space", "LCS_CMYK");
                        throw new RuntimeException("Not implemented yet.");
                    }
                }
            } else {
                this.properties.put("bmp_version", "BMP v. 5.x");
                throw new RuntimeException("BMP version 5 not implemented yet.");
            }
        }
        if (this.height > 0) {
            this.isBottomUp = true;
        } else {
            this.isBottomUp = false;
            this.height = Math.abs(this.height);
        }
        if (this.bitsPerPixel == 1 || this.bitsPerPixel == 4 || this.bitsPerPixel == 8) {
            this.numBands = 1;
            if (this.imageType == 0 || this.imageType == 1 || this.imageType == 2) {
                int n17 = this.palette.length / 3;
                if (n17 > 256) {
                    n17 = 256;
                }
                byte[] byArray = new byte[n17];
                byte[] byArray2 = new byte[n17];
                byte[] byArray3 = new byte[n17];
                for (n = 0; n < n17; ++n) {
                    n2 = 3 * n;
                    byArray3[n] = this.palette[n2];
                    byArray2[n] = this.palette[n2 + 1];
                    byArray[n] = this.palette[n2 + 2];
                }
            } else {
                int n18 = this.palette.length / 4;
                if (n18 > 256) {
                    n18 = 256;
                }
                byte[] byArray = new byte[n18];
                byte[] byArray4 = new byte[n18];
                byte[] byArray5 = new byte[n18];
                for (n = 0; n < n18; ++n) {
                    n2 = 4 * n;
                    byArray5[n] = this.palette[n2];
                    byArray4[n] = this.palette[n2 + 1];
                    byArray[n] = this.palette[n2 + 2];
                }
            }
        } else {
            this.numBands = this.bitsPerPixel == 16 ? 3 : (this.bitsPerPixel == 32 ? (this.alphaMask == 0 ? 3 : 4) : 3);
        }
    }

    private byte[] getPalette(int n) {
        if (this.palette == null) {
            return null;
        }
        byte[] byArray = new byte[this.palette.length / n * 3];
        int n2 = this.palette.length / n;
        for (int i = 0; i < n2; ++i) {
            int n3 = i * n;
            int n4 = i * 3;
            byArray[n4 + 2] = this.palette[n3++];
            byArray[n4 + 1] = this.palette[n3++];
            byArray[n4] = this.palette[n3];
        }
        return byArray;
    }

    private Image getImage() throws IOException, BadElementException {
        byte[] byArray = null;
        switch (this.imageType) {
            case 0: {
                return this.read1Bit(3);
            }
            case 1: {
                return this.read4Bit(3);
            }
            case 2: {
                return this.read8Bit(3);
            }
            case 3: {
                byArray = new byte[this.width * this.height * 3];
                this.read24Bit(byArray);
                return new ImgRaw(this.width, this.height, 3, 8, byArray);
            }
            case 4: {
                return this.read1Bit(4);
            }
            case 5: {
                switch ((int)this.compression) {
                    case 0: {
                        return this.read4Bit(4);
                    }
                    case 2: {
                        return this.readRLE4();
                    }
                }
                throw new RuntimeException("Invalid compression specified for BMP file.");
            }
            case 6: {
                switch ((int)this.compression) {
                    case 0: {
                        return this.read8Bit(4);
                    }
                    case 1: {
                        return this.readRLE8();
                    }
                }
                throw new RuntimeException("Invalid compression specified for BMP file.");
            }
            case 7: {
                byArray = new byte[this.width * this.height * 3];
                this.read24Bit(byArray);
                return new ImgRaw(this.width, this.height, 3, 8, byArray);
            }
            case 8: {
                return this.read1632Bit(false);
            }
            case 9: {
                return this.read1632Bit(true);
            }
            case 10: {
                return this.read1Bit(4);
            }
            case 11: {
                switch ((int)this.compression) {
                    case 0: {
                        return this.read4Bit(4);
                    }
                    case 2: {
                        return this.readRLE4();
                    }
                }
                throw new RuntimeException("Invalid compression specified for BMP file.");
            }
            case 12: {
                switch ((int)this.compression) {
                    case 0: {
                        return this.read8Bit(4);
                    }
                    case 1: {
                        return this.readRLE8();
                    }
                }
                throw new RuntimeException("Invalid compression specified for BMP file.");
            }
            case 13: {
                return this.read1632Bit(false);
            }
            case 14: {
                byArray = new byte[this.width * this.height * 3];
                this.read24Bit(byArray);
                return new ImgRaw(this.width, this.height, 3, 8, byArray);
            }
            case 15: {
                return this.read1632Bit(true);
            }
        }
        return null;
    }

    private Image indexedModel(byte[] byArray, int n, int n2) throws BadElementException {
        ImgRaw imgRaw = new ImgRaw(this.width, this.height, 1, n, byArray);
        PdfArray pdfArray = new PdfArray();
        pdfArray.add(PdfName.INDEXED);
        pdfArray.add(PdfName.DEVICERGB);
        byte[] byArray2 = this.getPalette(n2);
        int n3 = byArray2.length;
        pdfArray.add(new PdfNumber(n3 / 3 - 1));
        pdfArray.add(new PdfString(byArray2));
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.COLORSPACE, pdfArray);
        imgRaw.setAdditional(pdfDictionary);
        return imgRaw;
    }

    private void readPalette(int n) throws IOException {
        int n2;
        if (n == 0) {
            return;
        }
        this.palette = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = this.inputStream.read(this.palette, i, n - i);
            if (n2 >= 0) continue;
            throw new RuntimeException("incomplete palette");
        }
        this.properties.put("palette", this.palette);
    }

    private Image read1Bit(int n) throws IOException, BadElementException {
        byte[] byArray = new byte[(this.width + 7) / 8 * this.height];
        int n2 = 0;
        int n3 = (int)Math.ceil((double)this.width / 8.0);
        int n4 = n3 % 4;
        if (n4 != 0) {
            n2 = 4 - n4;
        }
        int n5 = (n3 + n2) * this.height;
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n5; i += this.inputStream.read(byArray2, i, n5 - i)) {
        }
        if (this.isBottomUp) {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, n5 - (i + 1) * (n3 + n2), byArray, i * n3, n3);
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, i * (n3 + n2), byArray, i * n3, n3);
            }
        }
        return this.indexedModel(byArray, 1, n);
    }

    private Image read4Bit(int n) throws IOException, BadElementException {
        byte[] byArray = new byte[(this.width + 1) / 2 * this.height];
        int n2 = 0;
        int n3 = (int)Math.ceil((double)this.width / 2.0);
        int n4 = n3 % 4;
        if (n4 != 0) {
            n2 = 4 - n4;
        }
        int n5 = (n3 + n2) * this.height;
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n5; i += this.inputStream.read(byArray2, i, n5 - i)) {
        }
        if (this.isBottomUp) {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, n5 - (i + 1) * (n3 + n2), byArray, i * n3, n3);
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, i * (n3 + n2), byArray, i * n3, n3);
            }
        }
        return this.indexedModel(byArray, 4, n);
    }

    private Image read8Bit(int n) throws IOException, BadElementException {
        byte[] byArray = new byte[this.width * this.height];
        int n2 = 0;
        int n3 = this.width * 8;
        if (n3 % 32 != 0) {
            n2 = (n3 / 32 + 1) * 32 - n3;
            n2 = (int)Math.ceil((double)n2 / 8.0);
        }
        int n4 = (this.width + n2) * this.height;
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4; i += this.inputStream.read(byArray2, i, n4 - i)) {
        }
        if (this.isBottomUp) {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, n4 - (i + 1) * (this.width + n2), byArray, i * this.width, this.width);
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, i * (this.width + n2), byArray, i * this.width, this.width);
            }
        }
        return this.indexedModel(byArray, 8, n);
    }

    private void read24Bit(byte[] byArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.width * 24;
        if (n4 % 32 != 0) {
            n3 = (n4 / 32 + 1) * 32 - n4;
            n3 = (int)Math.ceil((double)n3 / 8.0);
        }
        int n5 = (this.width * 3 + 3) / 4 * 4 * this.height;
        byte[] byArray2 = new byte[n5];
        try {
            for (n = 0; n < n5 && (n2 = this.inputStream.read(byArray2, n, n5 - n)) >= 0; n += n2) {
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        n = 0;
        if (this.isBottomUp) {
            int n6 = this.width * this.height * 3 - 1;
            n2 = -n3;
            for (int i = 0; i < this.height; ++i) {
                n = n6 - (i + 1) * this.width * 3 + 1;
                n2 += n3;
                for (int j = 0; j < this.width; ++j) {
                    byArray[n + 2] = byArray2[n2++];
                    byArray[n + 1] = byArray2[n2++];
                    byArray[n] = byArray2[n2++];
                    n += 3;
                }
            }
        } else {
            n2 = -n3;
            for (int i = 0; i < this.height; ++i) {
                n2 += n3;
                for (int j = 0; j < this.width; ++j) {
                    byArray[n + 2] = byArray2[n2++];
                    byArray[n + 1] = byArray2[n2++];
                    byArray[n] = byArray2[n2++];
                    n += 3;
                }
            }
        }
    }

    private int findMask(int n) {
        for (int i = 0; i < 32 && (n & 1) != 1; ++i) {
            n >>>= 1;
        }
        return n;
    }

    private int findShift(int n) {
        int n2;
        for (n2 = 0; n2 < 32 && (n & 1) != 1; ++n2) {
            n >>>= 1;
        }
        return n2;
    }

    private Image read1632Bit(boolean bl) throws IOException, BadElementException {
        int n;
        int n2 = this.findMask(this.redMask);
        int n3 = this.findShift(this.redMask);
        int n4 = n2 + 1;
        int n5 = this.findMask(this.greenMask);
        int n6 = this.findShift(this.greenMask);
        int n7 = n5 + 1;
        int n8 = this.findMask(this.blueMask);
        int n9 = this.findShift(this.blueMask);
        int n10 = n8 + 1;
        byte[] byArray = new byte[this.width * this.height * 3];
        int n11 = 0;
        if (!bl && (n = this.width * 16) % 32 != 0) {
            n11 = (n / 32 + 1) * 32 - n;
            n11 = (int)Math.ceil((double)n11 / 8.0);
        }
        if ((n = (int)this.imageSize) == 0) {
            n = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        int n12 = 0;
        if (this.isBottomUp) {
            for (int i = this.height - 1; i >= 0; --i) {
                int n13;
                n12 = this.width * 3 * i;
                for (n13 = 0; n13 < this.width; ++n13) {
                    int n14 = bl ? (int)this.readDWord(this.inputStream) : this.readWord(this.inputStream);
                    byArray[n12++] = (byte)((n14 >>> n3 & n2) * 256 / n4);
                    byArray[n12++] = (byte)((n14 >>> n6 & n5) * 256 / n7);
                    byArray[n12++] = (byte)((n14 >>> n9 & n8) * 256 / n10);
                }
                for (n13 = 0; n13 < n11; ++n13) {
                    this.inputStream.read();
                }
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                int n15;
                for (n15 = 0; n15 < this.width; ++n15) {
                    int n16 = bl ? (int)this.readDWord(this.inputStream) : this.readWord(this.inputStream);
                    byArray[n12++] = (byte)((n16 >>> n3 & n2) * 256 / n4);
                    byArray[n12++] = (byte)((n16 >>> n6 & n5) * 256 / n7);
                    byArray[n12++] = (byte)((n16 >>> n9 & n8) * 256 / n10);
                }
                for (n15 = 0; n15 < n11; ++n15) {
                    this.inputStream.read();
                }
            }
        }
        return new ImgRaw(this.width, this.height, 3, 8, byArray);
    }

    private Image readRLE8() throws IOException, BadElementException {
        int n = (int)this.imageSize;
        if (n == 0) {
            n = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += this.inputStream.read(byArray, i, n - i)) {
        }
        byte[] byArray2 = this.decodeRLE(true, byArray);
        n = this.width * this.height;
        if (this.isBottomUp) {
            byte[] byArray3 = new byte[byArray2.length];
            int n2 = this.width;
            for (int i = 0; i < this.height; ++i) {
                System.arraycopy(byArray2, n - (i + 1) * n2, byArray3, i * n2, n2);
            }
            byArray2 = byArray3;
        }
        return this.indexedModel(byArray2, 8, 4);
    }

    private Image readRLE4() throws IOException, BadElementException {
        int n;
        int n2;
        int n3;
        int n4 = (int)this.imageSize;
        if (n4 == 0) {
            n4 = (int)(this.bitmapFileSize - this.bitmapOffset);
        }
        byte[] byArray = new byte[n4];
        for (int i = 0; i < n4; i += this.inputStream.read(byArray, i, n4 - i)) {
        }
        byte[] byArray2 = this.decodeRLE(false, byArray);
        if (this.isBottomUp) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[this.width * this.height];
            int n5 = 0;
            for (n3 = this.height - 1; n3 >= 0; --n3) {
                n2 = n3 * this.width;
                n = n5 + this.width;
                while (n5 != n) {
                    byArray2[n5++] = byArray3[n2++];
                }
            }
        }
        int n6 = (this.width + 1) / 2;
        byte[] byArray4 = new byte[n6 * this.height];
        n2 = 0;
        n = 0;
        for (n3 = 0; n3 < this.height; ++n3) {
            for (int i = 0; i < this.width; ++i) {
                if ((i & 1) == 0) {
                    byArray4[n + i / 2] = (byte)(byArray2[n2++] << 4);
                    continue;
                }
                int n7 = n + i / 2;
                byArray4[n7] = (byte)(byArray4[n7] | (byte)(byArray2[n2++] & 0xF));
            }
            n += n6;
        }
        return this.indexedModel(byArray4, 4, 4);
    }

    private byte[] decodeRLE(boolean bl, byte[] byArray) {
        byte[] byArray2 = new byte[this.width * this.height];
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            block6: while (n4 < this.height && n < byArray.length) {
                int n5;
                int n6;
                int n7;
                if ((n7 = byArray[n++] & 0xFF) != 0) {
                    n6 = byArray[n++] & 0xFF;
                    if (bl) {
                        for (n5 = n7; n5 != 0; --n5) {
                            byArray2[n3++] = (byte)n6;
                        }
                    } else {
                        for (n5 = 0; n5 < n7; ++n5) {
                            byArray2[n3++] = (byte)((n5 & 1) == 1 ? n6 & 0xF : n6 >>> 4 & 0xF);
                        }
                    }
                    n2 += n7;
                    continue;
                }
                if ((n7 = byArray[n++] & 0xFF) == 1) break;
                switch (n7) {
                    case 0: {
                        n2 = 0;
                        n3 = ++n4 * this.width;
                        continue block6;
                    }
                    case 2: {
                        n3 = (n4 += byArray[n++] & 0xFF) * this.width + (n2 += byArray[n++] & 0xFF);
                        continue block6;
                    }
                }
                if (bl) {
                    for (n6 = n7; n6 != 0; --n6) {
                        byArray2[n3++] = (byte)(byArray[n++] & 0xFF);
                    }
                } else {
                    n6 = 0;
                    for (n5 = 0; n5 < n7; ++n5) {
                        if ((n5 & 1) == 0) {
                            n6 = byArray[n++] & 0xFF;
                        }
                        byArray2[n3++] = (byte)((n5 & 1) == 1 ? n6 & 0xF : n6 >>> 4 & 0xF);
                    }
                }
                n2 += n7;
                if (bl) {
                    if ((n7 & 1) != 1) continue;
                    ++n;
                    continue;
                }
                if ((n7 & 3) != 1 && (n7 & 3) != 2) continue;
                ++n;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return byArray2;
    }

    private int readUnsignedByte(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF;
    }

    private int readUnsignedShort(InputStream inputStream) throws IOException {
        int n = this.readUnsignedByte(inputStream);
        int n2 = this.readUnsignedByte(inputStream);
        return (n2 << 8 | n) & 0xFFFF;
    }

    private int readShort(InputStream inputStream) throws IOException {
        int n = this.readUnsignedByte(inputStream);
        int n2 = this.readUnsignedByte(inputStream);
        return n2 << 8 | n;
    }

    private int readWord(InputStream inputStream) throws IOException {
        return this.readUnsignedShort(inputStream);
    }

    private long readUnsignedInt(InputStream inputStream) throws IOException {
        int n = this.readUnsignedByte(inputStream);
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        int n4 = this.readUnsignedByte(inputStream);
        long l = n4 << 24 | n3 << 16 | n2 << 8 | n;
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n = this.readUnsignedByte(inputStream);
        int n2 = this.readUnsignedByte(inputStream);
        int n3 = this.readUnsignedByte(inputStream);
        int n4 = this.readUnsignedByte(inputStream);
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    private long readDWord(InputStream inputStream) throws IOException {
        return this.readUnsignedInt(inputStream);
    }

    private int readLong(InputStream inputStream) throws IOException {
        return this.readInt(inputStream);
    }
}

