/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.dbeditor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.echobase.entities.EchoBaseUserEntityEnum;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.services.service.DbEditorService;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.pager.FilterRule;
import org.nuiton.topia.persistence.pager.FilterRuleGroupOperator;
import org.nuiton.topia.persistence.pager.FilterRuleOperator;

public class GetEntities
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GetEntities.class);
    protected String entityId;
    protected EchoBaseUserEntityEnum entityType;
    protected Map<?, ?>[] datas;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;
    @Inject
    protected transient DbEditorService dbEditorService;
    @Inject
    protected transient DecoratorService decoratorService;

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(EchoBaseUserEntityEnum entityType) {
        this.entityType = entityType;
    }

    public Map<?, ?>[] getDatas() {
        return this.datas;
    }

    public String execute() throws Exception {
        Boolean ascendantOrder = this.isSortAscendant();
        String sortColumn = this.getSortColumn();
        this.initFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("filters      = " + this.getFilters()));
            log.debug((Object)("sidx         = " + sortColumn));
            log.debug((Object)("sord         = " + ascendantOrder));
        }
        this.datas = this.dbEditorService.getData(this.entityType, this.pager);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total page = " + this.getTotal()));
        }
        return "success";
    }

    public String entityModificationLogs() throws Exception {
        this.entityType = EchoBaseUserEntityEnum.EntityModificationLog;
        this.execute();
        return "success";
    }

    public String entityImportLogs() throws Exception {
        this.entityType = EchoBaseUserEntityEnum.ImportLog;
        if (StringUtils.isNotBlank((CharSequence)this.entityId)) {
            this.pager.setRules(Collections.singletonList(new FilterRule(FilterRuleOperator.eq, "entityId", this.entityId)));
            this.pager.setGroupOp(FilterRuleGroupOperator.AND);
        }
        this.execute();
        Map importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.values());
        for (Map row : this.datas) {
            String importType = (String)row.get("importType");
            String importTypeToString = (String)importTypes.get(importType);
            row.put("importType", importTypeToString);
            String entityId = (String)row.get("entityId");
            if (entityId == null || entityId.isEmpty()) continue;
            TopiaEntity entity = this.userDbPersistenceService.getEntity(entityId);
            this.decoratorService.decorateForeignKey(row, "entityId", entity, null);
        }
        return "success";
    }

    public String dashboardVoyageImportLogs() throws Exception {
        return this.dashboardImportLogs(EchoBaseUserEntityEnum.Voyage);
    }

    public String dashboardMooringImportLogs() throws Exception {
        return this.dashboardImportLogs(EchoBaseUserEntityEnum.Mooring);
    }

    public String dashboardImportLogs(EchoBaseUserEntityEnum type) throws Exception {
        this.entityType = type;
        this.execute();
        Decorator importLogDecorator = this.decoratorService.getDecorator(ImportLog.class, "dateOnly");
        Multimap importLogsByEntity = this.userDbPersistenceService.indexImportLogByEntityId();
        for (Map row : this.datas) {
            String id = (String)row.get("id");
            Collection importLogs = importLogsByEntity.get((Object)id);
            TopiaEntity entity = this.userDbPersistenceService.getEntity(id);
            this.decoratorService.decorateForeignKey(row, "id", entity, null);
            HashMap imports = Maps.newHashMap();
            ArrayListMultimap result = ArrayListMultimap.create();
            for (ImportLog importLog : importLogs) {
                String importLogToString = importLogDecorator.toString((Object)importLog);
                String importId = importLog.getTopiaId();
                imports.put(importId, importLogToString);
                result.put((Object)importLog.getImportType(), (Object)importId);
            }
            row.put("importLogs", imports);
            for (ImportType importType : result.keySet()) {
                row.put("importType." + importType.name(), result.get((Object)importType));
            }
        }
        return "success";
    }
}

