/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.EchoBaseTechnicalException;
import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.converter.FloatConverter;
import fr.ifremer.echobase.entities.DriverType;
import fr.ifremer.echobase.entities.EchoBaseInternalPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseInternalTopiaApplicationContext;
import fr.ifremer.echobase.entities.EchoBaseInternalTopiaPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserTopiaApplicationContext;
import fr.ifremer.echobase.io.EchoBaseIOUtil;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.services.service.UserService;
import fr.ifremer.echobase.services.service.embeddedapplication.EmbeddedApplicationService;
import fr.ifremer.echobase.services.service.spatial.GisService;
import fr.ifremer.echobase.services.service.workingDb.WorkingDbConfigurationService;
import fr.ifremer.echobase.ui.EchoBaseSession;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.nuiton.converter.ConverterUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.SortedProperties;

public class EchoBaseApplicationContext {
    private static Log log = LogFactory.getLog(EchoBaseApplicationContext.class);
    private static final String APPLICATION_CONTEXT_PARAMETER = "echobaseApplicationContext";
    protected Set<EchoBaseSession> sessions;
    protected boolean gisSupport;
    protected EchoBaseConfiguration configuration;
    protected EchoBaseDbMeta dbMeta;
    protected EchoBaseInternalTopiaApplicationContext internalTopiaApplicationContext;
    protected boolean defaultUsersCreated;
    protected long uploadFileMaxLength;

    public static EchoBaseApplicationContext getApplicationContext(ActionContext actionContext) {
        Map application = actionContext.getApplication();
        return (EchoBaseApplicationContext)application.get(APPLICATION_CONTEXT_PARAMETER);
    }

    public static EchoBaseApplicationContext getApplicationContext(ServletContext servletContext) {
        return (EchoBaseApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public static void setApplicationContext(ServletContext servletContext, EchoBaseApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    public static void removeApplicationContext(ServletContext servletContext) {
        servletContext.removeAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public Set<EchoBaseSession> getEchoBaseSessions() {
        return this.sessions;
    }

    public synchronized void registerEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        if (this.sessions == null) {
            this.sessions = Sets.newHashSet();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Register user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.add(session);
    }

    public synchronized void destroyEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        Preconditions.checkNotNull((Object)this.sessions);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroy user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.remove(session);
        session.close();
    }

    public boolean isGisSupport() {
        return this.gisSupport;
    }

    public void init() {
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("echobase-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        this.configuration = new EchoBaseConfiguration();
        try {
            this.initLog(this.configuration);
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.ALL, "Could not init logger.", e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)this.configuration.printConfig());
        }
        this.internalTopiaApplicationContext = EchoBaseInternalTopiaApplicationContext.newApplicationContext((File)this.configuration.getInternalDbDirectory());
        this.dbMeta = EchoBaseDbMeta.newDbMeta();
        EchoBaseServiceContext serviceContext = DefaultEchoBaseServiceContext.newContext((Locale)Locale.getDefault(), (EchoBaseConfiguration)this.getConfiguration(), (EchoBaseDbMeta)this.getDbMeta());
        this.initInternalDatabase(serviceContext);
        try {
            this.initBinDirectory();
        }
        catch (IOException e) {
            throw new TopiaException("Could not init bin directory", (Throwable)e);
        }
        try {
            this.extractFiles();
        }
        catch (IOException e) {
            throw new TopiaException("Could not extract files (drivers + embedded war)", (Throwable)e);
        }
        File lizmapConfig = this.getConfiguration().getLizmapApplicationConfigFile();
        this.gisSupport = lizmapConfig.exists();
        if (this.gisSupport) {
            this.initGisFiles();
        }
        URL resource = this.getClass().getResource("/struts.properties");
        Properties strutsProperties = new Properties();
        try (InputStream inputStream = resource.openStream();){
            strutsProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new TopiaException("Could not load struts configuration", (Throwable)e);
        }
        String property = strutsProperties.getProperty("struts.multipart.maxSize");
        this.uploadFileMaxLength = Long.valueOf(property);
        log.info((Object)("uploadFileMaxLength: " + this.uploadFileMaxLength));
    }

    public EchoBaseConfiguration getConfiguration() {
        return this.configuration;
    }

    public EchoBaseDbMeta getDbMeta() {
        return this.dbMeta;
    }

    public EchoBaseInternalTopiaApplicationContext getInternalTopiaApplicationContext() {
        return this.internalTopiaApplicationContext;
    }

    public boolean isDefaultUsersCreated() {
        return this.defaultUsersCreated;
    }

    public EchoBaseServiceContext newServiceContext(Locale locale, EchoBaseInternalPersistenceContext topiaInternalContext, EchoBaseUserPersistenceContext topiaUserContext, EchoBaseUserTopiaApplicationContext topiaApplicationContext) {
        EchoBaseServiceContext newServiceContext = DefaultEchoBaseServiceContext.newContext((Locale)locale, (EchoBaseConfiguration)this.configuration, (EchoBaseDbMeta)this.dbMeta);
        newServiceContext.setEchoBaseInternalPersistenceContext(topiaInternalContext);
        newServiceContext.setEchoBaseUserApplicationContext(topiaApplicationContext);
        newServiceContext.setEchoBaseUserPersistenceContext(topiaUserContext);
        return newServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.internalTopiaApplicationContext != null) {
                EchoBaseEntityHelper.releaseApplicationContext((TopiaApplicationContext)this.internalTopiaApplicationContext);
            }
        }
        finally {
            try {
                if (CollectionUtils.isNotEmpty((Collection)this.sessions)) {
                    for (EchoBaseSession session : this.sessions) {
                        this.destroyEchoBaseSession(session);
                    }
                }
            }
            finally {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                LogFactory.release((ClassLoader)contextClassLoader);
                Introspector.flushCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInternalDatabase(EchoBaseServiceContext serviceContext) throws TopiaException {
        Preconditions.checkNotNull((Object)this.configuration);
        Preconditions.checkNotNull((Object)this.dbMeta);
        Preconditions.checkNotNull((Object)this.internalTopiaApplicationContext);
        if (this.configuration.isUpdateSchema()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will update schema...");
            }
            this.internalTopiaApplicationContext.updateSchema();
        }
        EchoBaseInternalTopiaPersistenceContext tx = this.internalTopiaApplicationContext.newPersistenceContext();
        try {
            serviceContext.setEchoBaseInternalPersistenceContext((EchoBaseInternalPersistenceContext)tx);
            UserService service = (UserService)serviceContext.newService(UserService.class);
            List users = service.getUsers();
            if (CollectionUtils.isEmpty((Collection)users)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No user in database, will create default users.");
                }
                service.createDefaultUsers();
            }
            if (this.configuration.isEmbedded()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Will try to create default working db configuration for internal db.");
                }
                ((WorkingDbConfigurationService)serviceContext.newService(WorkingDbConfigurationService.class)).createEmbeddedWorkingDbConfiguration();
            }
        }
        finally {
            serviceContext.setEchoBaseInternalPersistenceContext(null);
            EchoBaseEntityHelper.closeConnection((AbstractTopiaPersistenceContext)tx);
        }
    }

    protected void initLog(EchoBaseConfiguration configuration) throws IOException {
        File logFile = configuration.getLogConfigFile();
        if (!logFile.exists()) {
            EmbeddedApplicationService.copyEmbeddedBinaryFile((String)logFile.getName(), (File)logFile.getParentFile());
            RecursiveProperties properties = new RecursiveProperties();
            BufferedReader reader = Files.newReader((File)logFile, (Charset)Charsets.UTF_8);
            Object object = null;
            try {
                properties.load((Reader)reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            properties.setProperty("echobase.log.dir", configuration.getDefaultLogDirectory().getAbsolutePath());
            SortedProperties p2 = new SortedProperties();
            for (Map.Entry entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                p2.setProperty(key, properties.getProperty(key));
            }
            p2.remove("echobase.log.dir");
            try (BufferedWriter writer = Files.newWriter((File)logFile, (Charset)Charsets.UTF_8);){
                p2.store(writer, "Generated by " + this.getClass().getName());
            }
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((String)logFile.getAbsolutePath());
        log = LogFactory.getLog(EchoBaseApplicationContext.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Use now logFile: " + logFile));
        }
    }

    protected void extractFiles() throws IOException {
        File libDirectory = this.configuration.getLibDirectory();
        for (DriverType driverType : DriverType.values()) {
            String pilotFileName = driverType.getPilotFileName(this.configuration);
            if (log.isInfoEnabled()) {
                log.info((Object)("Copy embedded resource " + pilotFileName + " to directory " + libDirectory));
            }
            EmbeddedApplicationService.copyEmbeddedBinaryFile((String)pilotFileName, (File)libDirectory);
        }
        if (!this.getConfiguration().isEmbedded()) {
            File warLocation = this.configuration.getWarLocation();
            File embeddedWarDirectory = warLocation.getParentFile();
            String embeddedWarFileName = warLocation.getName();
            if (log.isInfoEnabled()) {
                log.info((Object)("Copy embedded war " + embeddedWarFileName + " to directory " + embeddedWarDirectory));
            }
            EmbeddedApplicationService.copyEmbeddedBinaryFile((String)embeddedWarFileName, (File)embeddedWarDirectory);
        }
    }

    protected void initBinDirectory() throws IOException {
        File binDirectory = this.configuration.getBinDirectory();
        EchoBaseIOUtil.forceMkdir((File)binDirectory);
        File updateExecutablePath = this.configuration.getUpdateExecutablePath();
        String updateExecutablePathName = updateExecutablePath.getName();
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy embedded resource " + updateExecutablePathName + " to directory " + binDirectory));
        }
        EmbeddedApplicationService.copyEmbeddedBinaryFile((String)updateExecutablePathName, (File)binDirectory);
    }

    protected void initGisFiles() {
        try {
            GisService.copyQgisDefaultTemplateFileIfNecessary((EchoBaseConfiguration)this.configuration);
            GisService.copyQgisResourcesIfNecessary((EchoBaseConfiguration)this.configuration);
            GisService.copyLizmapDefaultTemplateFileIfNecessary((EchoBaseConfiguration)this.configuration);
            EchoBaseIOUtil.forceMkdir((File)this.configuration.getLizmapProjectsDirectory());
        }
        catch (IOException e) {
            throw new EchoBaseTechnicalException("Could not create gis support files", (Throwable)e);
        }
        if (!this.configuration.getQgisTemplateFile().exists() && log.isWarnEnabled()) {
            log.warn((Object)("disable gisSupport : Could not found Qgis template at: " + this.configuration.getQgisTemplateFile()));
        }
        if (!this.configuration.getLizmapTemplateFile().exists() && log.isWarnEnabled()) {
            log.warn((Object)("disable gisSupport : Could not found Lizmap template at: " + this.configuration.getLizmapTemplateFile()));
        }
    }

    public long getUploadFileMaxLength() {
        return this.uploadFileMaxLength;
    }
}

