/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureFiles.java 116 2011-11-24 23:06:43Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureFiles.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.ImportDataConfiguration;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

import java.io.File;
import java.io.IOException;

/**
 * Action to load input files to import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ConfigureFiles extends EchoBaseActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ConfigureFiles.class);

    /** Import data configuration to push in session. */
    protected ImportDataConfiguration model;

    /** Id of selected voyage used in import. */
    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public void setAcoustic(File file) {
        getModel().getAcousticFile().setFile(file);
    }

    public void setAcousticContentType(String contentType) {
        getModel().getAcousticFile().setContentType(contentType);
    }

    public void setAcousticFileName(String fileName) {
        getModel().getAcousticFile().setFileName(fileName);
    }

    public void setCapture(File file) {
        getModel().getCaptureFile().setFile(file);
    }

    public void setCaptureContentType(String contentType) {
        getModel().getCaptureFile().setContentType(contentType);
    }

    public void setCaptureFileName(String fileName) {
        getModel().getCaptureFile().setFileName(fileName);
    }

    public void setLectureAgeGen(File file) {
        getModel().getLectureAgeGenFile().setFile(file);
    }

    public void setLectureAgeGenContentType(String contentType) {
        getModel().getLectureAgeGenFile().setContentType(contentType);
    }

    public void setLectureAgeGenFileName(String fileName) {
        getModel().getLectureAgeGenFile().setFileName(fileName);
    }

    public void setEvents(File file) {
        getModel().getEventsFile().setFile(file);
    }

    public void setEventsContentType(String contentType) {
        getModel().getEventsFile().setContentType(contentType);
    }

    public void setEventsFileName(String fileName) {
        getModel().getEventsFile().setFileName(fileName);
    }

    public void setTypeEchoSpecies(File file) {
        getModel().getTypeEchoSpeciesFile().setFile(file);
    }

    public void setTypeEchoSpeciesContentType(String contentType) {
        getModel().getTypeEchoSpeciesFile().setContentType(contentType);
    }

    public void setTypeEchoSpeciesFileName(String fileName) {
        getModel().getTypeEchoSpeciesFile().setFileName(fileName);
    }

    public String getVoyageId() {
        return voyageId;
    }

    public ImportDataConfiguration getModel() {
        if (model == null) {
            model = new ImportDataConfiguration(getLocale());
        }
        return model;
    }

    @Override
    public String input() throws Exception {

        // remove configuration from session
        getEchoBaseSession().setImportDataConfiguration(null);

        return INPUT;
    }

    @Override
    public String execute() throws Exception {

        ImportDataConfiguration importModel = getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-import" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info("Temporary directory to use : " + dataDirectory);
        }
        copyFile(importModel.getAcousticFile(), dataDirectory);
        copyFile(importModel.getCaptureFile(), dataDirectory);
        copyFile(importModel.getEventsFile(), dataDirectory);
        copyFile(importModel.getLectureAgeGenFile(), dataDirectory);
        copyFile(importModel.getTypeEchoSpeciesFile(), dataDirectory);

        getEchoBaseSession().setImportDataConfiguration(importModel);
        return SUCCESS;
    }

    @Override
    public void prepare() throws Exception {

        VoyageService service = newService(VoyageService.class);

        Voyage voyage = service.getEntityById(Voyage.class, voyageId);
        getModel().setVoyage(voyage);
    }

    protected void copyFile(InputFile inputFile, File dataDirectory) throws IOException {
        File source = inputFile.getFile();
        if (source != null) {

            File target = new File(dataDirectory, inputFile.getFileName());
            if (log.isInfoEnabled()) {
                log.info("Copy file " + source + " to " + target);
            }
            FileUtils.copyFile(source, target);

            // keep target (source file will be removed at the end of this action)
            inputFile.setFile(target);
        }

    }
}
