/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.rsa.RSAPrivateCrtKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyCryptix;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static final int KEYSIZE_MIN = 384;
    private static final int KEYSIZE_DEFAULT = 3072;
    private static final int KEYSIZE_MAX = 16384;
    private static final int CERTAINTY = 80;
    private int keysize;
    private BigInteger publicExponent;
    private SecureRandom random;
    private boolean initialized = false;

    public KeyPair generateKeyPair() {
        BigInteger d;
        BigInteger qMinus1;
        BigInteger pMinus1;
        BigInteger n;
        BigInteger q;
        BigInteger p;
        if (!this.initialized) {
            this.initialize();
        }
        int pLen = this.keysize / 2;
        int qLen = this.keysize - pLen;
        BigInteger e = this.publicExponent;
        while (true) {
            try {
                do {
                    p = new BigInteger(pLen, 80, this.random);
                    q = new BigInteger(qLen, 80, this.random);
                    n = p.multiply(q);
                } while (p.compareTo(q) == 0 || n.bitLength() != this.keysize);
                pMinus1 = p.subtract(ONE);
                qMinus1 = q.subtract(ONE);
                BigInteger phi = pMinus1.multiply(qMinus1);
                d = e.modInverse(phi);
            }
            catch (ArithmeticException arithmeticException) {
                continue;
            }
            break;
        }
        BigInteger primeExponentP = d.mod(pMinus1);
        BigInteger primeExponentQ = d.mod(qMinus1);
        BigInteger crtCoefficient = q.modInverse(p);
        BigInteger x = new BigInteger(pLen, this.random);
        BigInteger y = RSAAlgorithm.rsa(x, n, e);
        BigInteger z = RSAAlgorithm.rsa(y, n, d, p, q, primeExponentP, primeExponentQ, crtCoefficient);
        if (!z.equals(x)) {
            throw new RuntimeException("RSA KeyPair doesn't work");
        }
        RSAPrivateCrtKeyCryptix priv = new RSAPrivateCrtKeyCryptix(n, e, d, p, q, primeExponentP, primeExponentQ, crtCoefficient);
        RSAPublicKeyCryptix pub = new RSAPublicKeyCryptix(n, e);
        return new KeyPair(pub, priv);
    }

    private void initialize() {
        this.initialize(3072, new SecureRandom());
    }

    public void initialize(int keysize, SecureRandom random) {
        if (keysize < 384 || keysize > 16384) {
            throw new IllegalArgumentException("keysize: invalid size (" + keysize + ")");
        }
        this.keysize = keysize;
        this.random = random;
        this.publicExponent = F4;
        this.initialized = true;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new RuntimeException("NYI");
    }
}

