/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class RSACipher_OAEP
extends CipherSpi {
    private final MessageDigest _md;
    private final int _hLen;
    private final byte[] _lHash;
    private SecureRandom _rng;
    private BigInteger _n;
    private BigInteger _exp;
    private BigInteger _p;
    private BigInteger _q;
    private BigInteger _u;
    private int _k;
    private int _mode;

    public RSACipher_OAEP(String hashName) {
        try {
            this._md = MessageDigest.getInstance(hashName);
            this._hLen = this._md.getDigestLength();
            this._lHash = this._md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InternalError("MessageDigest not found! (" + hashName + "): " + ex.toString());
        }
    }

    private byte[] RSAES_OAEP_DECRYPT(byte[] C) throws BadPaddingException, IllegalBlockSizeException {
        if (C.length != this._k) {
            throw new IllegalBlockSizeException();
        }
        BigInteger c = new BigInteger(1, C);
        BigInteger m = null;
        try {
            m = RSAAlgorithm.rsa(c, this._n, this._exp, this._p, this._q, this._u);
        }
        catch (ArithmeticException arithmeticException) {
            throw new BadPaddingException("ArithmeticException during decrypt! Bad key perhaps?");
        }
        byte[] EM = Util.toFixedLenByteArray(m, this._k);
        if (EM.length != this._k) {
            throw new BadPaddingException();
        }
        if (EM[0] != 0) {
            throw new BadPaddingException();
        }
        byte[] maskedSeed = new byte[this._hLen];
        System.arraycopy(EM, 1, maskedSeed, 0, maskedSeed.length);
        byte[] maskedDB = new byte[this._k - this._hLen - 1];
        System.arraycopy(EM, 1 + this._hLen, maskedDB, 0, maskedDB.length);
        byte[] seedMask = this.mgf1(maskedDB, this._hLen);
        byte[] seed = RSACipher_OAEP.xor(maskedSeed, seedMask);
        byte[] dbMask = this.mgf1(seed, this._k - this._hLen - 1);
        byte[] DB = RSACipher_OAEP.xor(maskedDB, dbMask);
        byte[] lHash1 = new byte[this._hLen];
        System.arraycopy(DB, 0, lHash1, 0, lHash1.length);
        if (!Util.equals(this._lHash, lHash1)) {
            throw new BadPaddingException();
        }
        int i = this._hLen;
        while (i < DB.length) {
            if (DB[i] != 0) break;
            ++i;
        }
        if (DB[i++] != 1) {
            throw new BadPaddingException();
        }
        int mLen = DB.length - i;
        byte[] M = new byte[mLen];
        System.arraycopy(DB, i, M, 0, mLen);
        return M;
    }

    private byte[] RSAES_OAEP_ENCRYPT(byte[] M) throws IllegalBlockSizeException {
        int mLen = M.length;
        if (mLen > this._k - 2 * this._hLen - 2) {
            throw new IllegalBlockSizeException();
        }
        byte[] PS = new byte[this._k - mLen - 2 * this._hLen - 2];
        byte[] DB = this.concat(this._lHash, PS, new byte[]{1}, M);
        byte[] seed = new byte[this._hLen];
        this._rng.nextBytes(seed);
        byte[] dbMask = this.mgf1(seed, this._k - this._hLen - 1);
        byte[] maskedDB = RSACipher_OAEP.xor(DB, dbMask);
        byte[] seedMask = this.mgf1(maskedDB, this._hLen);
        byte[] maskedSeed = RSACipher_OAEP.xor(seed, seedMask);
        byte[] EM = this.concat(new byte[1], maskedSeed, maskedDB);
        BigInteger m = new BigInteger(1, EM);
        BigInteger c = null;
        try {
            c = RSAAlgorithm.rsa(m, this._n, this._exp, this._p, this._q, this._u);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalBlockSizeException("ArithmeticException during encrypt! Bad key perhaps?");
        }
        byte[] C = Util.toFixedLenByteArray(c, this._k);
        if (C.length != this._k) {
            throw new IllegalBlockSizeException();
        }
        return C;
    }

    private byte[] concat(byte[] a, byte[] b) {
        byte[] res = new byte[a.length + b.length];
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    private byte[] concat(byte[] a, byte[] b, byte[] c) {
        return this.concat(a, this.concat(b, c));
    }

    private byte[] concat(byte[] a, byte[] b, byte[] c, byte[] d) {
        return this.concat(a, this.concat(b, this.concat(c, d)));
    }

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this._mode == 1) {
            byte[] M = new byte[inputLen];
            System.arraycopy(input, inputOffset, M, 0, inputLen);
            byte[] C = this.RSAES_OAEP_ENCRYPT(M);
            return C;
        }
        byte[] C = new byte[inputLen];
        System.arraycopy(input, inputOffset, C, 0, inputLen);
        byte[] M = this.RSAES_OAEP_DECRYPT(C);
        return M;
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] M = new byte[inputLen];
        System.arraycopy(input, inputOffset, M, 0, inputLen);
        byte[] C = this.RSAES_OAEP_ENCRYPT(M);
        int outputLen = output.length - outputOffset;
        if (C.length > outputLen) {
            throw new ShortBufferException();
        }
        System.arraycopy(C, 0, output, outputOffset, C.length);
        return C.length;
    }

    protected final int engineGetBlockSize() {
        throw new IllegalArgumentException();
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA key.");
    }

    protected final int engineGetOutputSize(int inputLen) {
        throw new IllegalArgumentException();
    }

    protected final AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
        }
        this.engineInit(opmode, key, random);
    }

    protected final void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey) && !(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Key must be instance of either RSAPublicKey or RSAPrivateKey!");
        }
        this._mode = opmode;
        this._rng = random;
        if (this._mode == 2) {
            this._n = ((RSAPrivateKey)key).getModulus();
            this._exp = ((RSAPrivateKey)key).getPrivateExponent();
        } else if (this._mode == 1) {
            this._n = ((RSAPublicKey)key).getModulus();
            this._exp = ((RSAPublicKey)key).getPublicExponent();
        } else {
            throw new IllegalArgumentException("opmode not supported.");
        }
        if (key instanceof RSAPrivateCrtKey) {
            this._p = ((RSAPrivateCrtKey)key).getPrimeP();
            this._q = ((RSAPrivateCrtKey)key).getPrimeQ();
            this._u = ((RSAPrivateCrtKey)key).getCrtCoefficient();
        } else {
            this._u = null;
            this._q = null;
            this._p = null;
        }
        this._k = (this._n.bitLength() + 7) / 8;
        if (this._k < 2 * this._hLen + 2) {
            throw new InvalidKeyException("Modulus too short.");
        }
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
        }
        this.engineInit(opmode, key, random);
    }

    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Wrong mode type!");
    }

    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
    }

    protected final byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        throw new RuntimeException("You can't do an update when using OAEP!");
    }

    protected final int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using OAEP!");
    }

    private byte[] mgf1(byte[] seed, int len) {
        int hashCount = (len + this._hLen - 1) / this._hLen;
        byte[] mask = new byte[]{};
        int i = 0;
        while (i < hashCount) {
            mask = this.concat(mask, this.mgf1Hash(seed, (byte)i));
            ++i;
        }
        byte[] res = new byte[len];
        System.arraycopy(mask, 0, res, 0, res.length);
        return res;
    }

    private byte[] mgf1Hash(byte[] seed, byte c) {
        this._md.update(seed);
        this._md.update(new byte[3]);
        this._md.update(c);
        return this._md.digest();
    }

    private static byte[] xor(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new InternalError("a.len != b.len");
        }
        byte[] res = new byte[a.length];
        int i = 0;
        while (i < res.length) {
            res[i] = (byte)(a[i] ^ b[i]);
            ++i;
        }
        return res;
    }
}

