/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.examples;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public final class FileDEncryption {
    private String inputFile;
    private String outputFile;
    private Key secretKey;
    private String keyfile;
    private String alg;
    private boolean running_enc;
    private String provider;
    private String mode;
    private byte[] iv;

    public FileDEncryption(String filename, Key key, byte[] iVector, String algorithm, String amode, String padding, String prov) {
        this.inputFile = filename;
        this.outputFile = String.valueOf(filename) + "." + algorithm + "." + amode + "." + padding;
        this.alg = String.valueOf(algorithm) + "/" + amode + "/" + padding;
        this.mode = amode;
        this.secretKey = key;
        this.iv = iVector;
        this.keyfile = String.valueOf(this.outputFile) + "." + "key";
        this.provider = prov;
    }

    private boolean ciphering(int way) {
        boolean ret = false;
        boolean ok = false;
        IvParameterSpec ivSpec = null;
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.alg, this.provider);
            if (this.mode == "ECB") {
                cipher.init(way, this.secretKey);
            } else {
                ivSpec = new IvParameterSpec(this.iv);
                cipher.init(way, this.secretKey, ivSpec);
            }
            ok = true;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (NoSuchPaddingException nspe) {
            nspe.printStackTrace();
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
        }
        if (!ok) {
            return false;
        }
        FileInputStream fInput = null;
        FileOutputStream fOutput = null;
        CipherOutputStream cStr = null;
        try {
            if (this.running_enc) {
                fInput = new FileInputStream(this.inputFile);
                fOutput = new FileOutputStream(String.valueOf(this.outputFile) + ".encrypted");
                cStr = new CipherOutputStream(fOutput, cipher);
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = fInput.read(buffer)) != -1) {
                    cStr.write(buffer, 0, length);
                }
                fInput.close();
                cStr.close();
            } else {
                CipherInputStream ciStr = null;
                fInput = new FileInputStream(String.valueOf(this.outputFile) + ".encrypted");
                ciStr = new CipherInputStream(fInput, cipher);
                fOutput = new FileOutputStream(String.valueOf(this.outputFile) + ".decrypted");
                byte[] buffer = new byte[8192];
                int length = 0;
                while ((length = ciStr.read(buffer)) != -1) {
                    fOutput.write(buffer, 0, length);
                }
                ciStr.close();
                fOutput.close();
            }
            ret = true;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("File not found! " + fnfe.getMessage());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("IOException! " + ioe.getMessage());
            ioe.printStackTrace();
        }
        return ret;
    }

    private boolean getKeyWithIV() {
        boolean res = false;
        FileInputStream fInput = null;
        try {
            fInput = new FileInputStream(this.keyfile);
            ObjectInputStream objIStream = new ObjectInputStream(fInput);
            this.secretKey = (Key)objIStream.readObject();
            this.iv = new byte[fInput.available()];
            fInput.read(this.iv);
            objIStream.close();
            System.out.println("Read key!\n");
            res = true;
        }
        catch (StreamCorruptedException sce) {
            sce.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (OptionalDataException ode) {
            ode.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return res;
    }

    public final synchronized boolean go() {
        this.running_enc = true;
        boolean result = this.saveKeyWithIV();
        result = result ? this.ciphering(1) : (result ^= true);
        return result;
    }

    public final synchronized boolean reTurn() {
        this.running_enc = false;
        boolean result = this.getKeyWithIV();
        result = result ? this.ciphering(2) : (result ^= true);
        return result;
    }

    private boolean saveKeyWithIV() {
        boolean res = false;
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(this.keyfile);
            ObjectOutputStream objStr = new ObjectOutputStream(fOut);
            objStr.writeObject(this.secretKey);
            if (this.mode != "ECB") {
                fOut.write(this.iv);
            }
            objStr.close();
            fOut.close();
            res = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found!\n");
        }
        catch (IOException iOException) {
            System.out.println("IOException!\n");
        }
        return res;
    }
}

