package com.jurismarches.vradi.services;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

import com.caucho.hessian.server.HessianServlet;

/**
 * HessianServer.
 *
 * @author $Author: schorlet $
 * @version $Revision: 539 $ $Date: 2010-02-19 04:58:56 +0100 (ven., 19 févr. 2010) $
 * @since 17 févr. 2010 21:14:36
 */
public class HessianServer {
    final Server server;
    
    public HessianServer(int port) throws Exception {
        server = new Server(9000);
        server.setStopAtShutdown(true);
    }
    
    protected void start() throws Exception {
        System.out.println("Starting Server");

        HessianServlet storageServlet = new HessianServlet();
        storageServlet.setHomeAPI(VradiStorageService.class);
        storageServlet.setHome(new VradiStorageServiceImpl());
        
        HessianServlet xmlStreamServlet = new HessianServlet();
        xmlStreamServlet.setHomeAPI(XmlStreamService.class);
        xmlStreamServlet.setHome(new XmlStreamServiceImpl());
        
        HessianServlet mailingServlet = new HessianServlet();
        mailingServlet.setHomeAPI(MailingService.class);
        mailingServlet.setHome(new MailingServiceImpl());
        
        Context root = new Context(server, "/");
        root.addServlet(new ServletHolder(storageServlet), "/storage");
        root.addServlet(new ServletHolder(xmlStreamServlet), "/xmlstream");
        root.addServlet(new ServletHolder(mailingServlet), "/mailing");

        server.start();
    }

    protected void stop() throws Exception {
        server.stop();
    }

    
    public static void main(String args[]) throws Exception {
        HessianServer server = new HessianServer(9000);
        server.start();
        System.out.println("Server ready");

        Thread.sleep(5 * 60 * 1000);
        server.stop();
        System.exit(0);
    }

}
