/*
 * *##% 
 * vradi-entities
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.entities;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.FieldType.TYPE;

/**
 * @author letellier
 */
public enum FieldTypeEnum {
    STRING(FieldType.TYPE.STRING, "Chaine", 0, 1),
    TEXT(FieldType.TYPE.STRING, "Texte", 0, 1),
    DATE(FieldType.TYPE.DATE, "Date", 1, 1),
    EMAIL(FieldType.TYPE.STRING, "Email", 0, 1),
    URL(FieldType.TYPE.STRING, "Url", 0, 1),
    NUMBER(FieldType.TYPE.NUMERIC, "Nombre", 1, 1);

    protected String TAG_VALUE = "use";
    protected String tagValue;
    protected FieldType type;

    FieldTypeEnum(TYPE type, String tagValue, int min, int max) {
        this.tagValue = tagValue;
        this.type = new FieldType(type, min, max);
        this.type.addTagValue(TAG_VALUE, tagValue);
    }

    public String getTagValue() {
        return tagValue;
    }

    public FieldType getFieldType() {
        return type;
    }

    public boolean isType(FieldType type) {
        return tagValue.equals(type.getTagValue(TAG_VALUE));
    }

    @Override
    public String toString() {
        return getTagValue();
    }
}
