/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import org.h2.bnf.context.DbSchema;
import org.h2.command.Parser;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbContents {
    private DbSchema[] schemas;
    private DbSchema defaultSchema;
    private boolean isOracle;
    private boolean isH2;
    private boolean isPostgreSQL;
    private boolean isDerby;
    private boolean isSQLite;
    private boolean isH2ModeMySQL;
    private boolean isMySQL;
    private boolean isFirebird;
    private boolean isMSSQLServer;

    public DbSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isH2ModeMySQL() {
        return this.isH2ModeMySQL;
    }

    public boolean isMSSQLServer() {
        return this.isMSSQLServer;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isSQLite() {
        return this.isSQLite;
    }

    public DbSchema[] getSchemas() {
        return this.schemas;
    }

    public synchronized void readContents(String string, Connection connection) throws SQLException {
        Object object;
        Wrapper wrapper;
        this.isH2 = string.startsWith("jdbc:h2:");
        if (this.isH2) {
            wrapper = connection.prepareStatement("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?");
            wrapper.setString(1, "MODE");
            object = wrapper.executeQuery();
            object.next();
            if ("MYSQL".equals(object.getString(1))) {
                this.isH2ModeMySQL = true;
            }
            object.close();
            wrapper.close();
        }
        this.isSQLite = string.startsWith("jdbc:sqlite:");
        this.isOracle = string.startsWith("jdbc:oracle:");
        this.isPostgreSQL = string.startsWith("jdbc:postgresql:") || string.startsWith("jdbc:vertica:");
        this.isMySQL = string.startsWith("jdbc:mysql:");
        this.isDerby = string.startsWith("jdbc:derby:");
        this.isFirebird = string.startsWith("jdbc:firebirdsql:");
        this.isMSSQLServer = string.startsWith("jdbc:sqlserver:");
        wrapper = connection.getMetaData();
        object = this.getDefaultSchemaName((DatabaseMetaData)wrapper);
        String[] stringArray = this.getSchemaNames((DatabaseMetaData)wrapper);
        this.schemas = new DbSchema[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DbSchema[] dbSchemaArray = stringArray[i];
            int n = object == null || ((String)object).equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n != 0);
            if (n != 0) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i] = dbSchema;
            String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM", "EXTERNAL"};
            dbSchema.readTables((DatabaseMetaData)wrapper, stringArray2);
            if (this.isPostgreSQL) continue;
            dbSchema.readProcedures((DatabaseMetaData)wrapper);
        }
        if (this.defaultSchema == null) {
            String string2 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string2 != null && dbSchema.name.length() >= string2.length()) continue;
                string2 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray;
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String> arrayList = New.arrayList();
        while (resultSet.next()) {
            stringArray = resultSet.getString("TABLE_SCHEM");
            String[] stringArray2 = null;
            if (this.isOracle) {
                stringArray2 = new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"};
            } else if (this.isMSSQLServer) {
                stringArray2 = new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"};
            }
            if (stringArray2 != null) {
                for (void var9_9 : stringArray2) {
                    if (!var9_9.equals(stringArray)) continue;
                    stringArray = null;
                    break;
                }
            }
            if (stringArray == null) continue;
            arrayList.add((String)stringArray);
        }
        resultSet.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String quoteIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(string);
        }
        return StringUtils.toUpperEnglish(string);
    }
}

