/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.web.action;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailGroup;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.franciaflex.faxtomail.web.action.SearchAction;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.decorator.Decorator;

@InterceptorRefs(value={@InterceptorRef(value="faxToMailInterceptor"), @InterceptorRef(value="paramsPrepareParamsStack")})
public class SearchAction
extends FaxToMailActionSupport {
    private static final Log log = LogFactory.getLog(SearchAction.class);
    protected EmailService emailService;
    protected ConfigurationService configurationService;
    protected DecoratorService decoratorService;
    protected String element;
    protected String company;
    protected List<Email> results;
    protected String singleResultId;
    protected Map<MailField, String> tableMailFields;

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setDecoratorService(DecoratorService decoratorService) {
        this.decoratorService = decoratorService;
    }

    @Action(value="search-input")
    public String input() throws Exception {
        return "input";
    }

    @Action(value="search", results={@Result(name="detail", type="redirectAction", params={"actionName", "demand-detail", "id", "%{singleResultId}"})})
    public String execute() throws Exception {
        String result = "input";
        if (this.element != null && this.company != null) {
            this.results = new ArrayList(this.emailService.searchArchives(this.element, this.company));
            if (this.results.size() == 1) {
                this.singleResultId = ((Email)this.results.get(0)).getTopiaId();
                result = "detail";
            } else {
                List mailFields = this.configurationService.getSearchDisplayColumns();
                if (CollectionUtils.isEmpty((Collection)mailFields)) {
                    mailFields = Lists.newArrayList((Object[])MailField.getTableFields());
                }
                this.tableMailFields = this.getEnumAsMap((Object[])mailFields.toArray(new MailField[mailFields.size()]));
            }
        }
        return result;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public List<Email> getResults() {
        return this.results;
    }

    public void setResults(List<Email> results) {
        this.results = results;
    }

    public String getSingleResultId() {
        return this.singleResultId;
    }

    public Map<MailField, String> getTableMailFields() {
        return this.tableMailFields;
    }

    public String getAttr(MailField field, Email email) {
        Decorator decorator;
        Object attrValue = null;
        switch (4.$SwitchMap$com$franciaflex$faxtomail$persistence$entities$MailField[field.ordinal()]) {
            case 1: {
                attrValue = email.getPriority();
                break;
            }
            case 2: {
                attrValue = email.getDemandType();
                break;
            }
            case 3: {
                attrValue = email.getObject();
                break;
            }
            case 4: {
                Client client = email.getClient();
                attrValue = client == null ? null : client.getCode();
                break;
            }
            case 5: {
                Client client = email.getClient();
                attrValue = client == null ? null : client.getName();
                break;
            }
            case 6: {
                Client client = email.getClient();
                attrValue = client == null ? null : client.getBrand();
                break;
            }
            case 7: {
                attrValue = email.getSender();
                break;
            }
            case 8: {
                attrValue = email.getProjectReference();
                break;
            }
            case 9: {
                attrValue = email.getCompanyReference();
                break;
            }
            case 10: {
                attrValue = email.getReference();
                break;
            }
            case 11: {
                attrValue = email.getReceptionDate();
                break;
            }
            case 12: {
                attrValue = email.getRecipient();
                break;
            }
            case 13: {
                attrValue = email.getDemandStatus();
                break;
            }
            case 14: {
                attrValue = email.getWaitingState();
                break;
            }
            case 15: {
                int intAttrValue = 0;
                for (RangeRow rr : email.getRangeRow()) {
                    Integer productQuantity = rr.getProductQuantity();
                    if (productQuantity == null) continue;
                    intAttrValue += productQuantity.intValue();
                }
                attrValue = intAttrValue;
                break;
            }
            case 16: {
                int intAttrValue = 0;
                for (RangeRow rr : email.getRangeRow()) {
                    Integer savQuantity = rr.getSavQuantity();
                    if (savQuantity == null) continue;
                    intAttrValue += savQuantity.intValue();
                }
                attrValue = intAttrValue;
                break;
            }
            case 17: {
                int intAttrValue = 0;
                for (RangeRow rr : email.getRangeRow()) {
                    Integer quotationQuantity = rr.getQuotationQuantity();
                    if (quotationQuantity == null) continue;
                    intAttrValue += quotationQuantity.intValue();
                }
                attrValue = intAttrValue;
                break;
            }
            case 18: {
                attrValue = email.getTakenBy();
                break;
            }
            case 19: {
                attrValue = email.getComment();
                break;
            }
            case 20: {
                attrValue = email.getEdiError();
                break;
            }
            case 21: {
                attrValue = email.getLastAttachmentOpener();
                break;
            }
            case 22: {
                attrValue = "<span class='fa fa-envelope-o'></span>&nbsp;" + email.sizeReplies();
                break;
            }
            case 23: {
                attrValue = "<span class='fa fa-paperclip'></span>&nbsp;" + email.sizeAttachment();
                break;
            }
            case 24: {
                EmailGroup emailGroup = email.getEmailGroup();
                attrValue = "<span class='fa fa-link'></span>&nbsp;" + (emailGroup == null ? 1 : emailGroup.sizeEmail());
            }
        }
        String result = attrValue == null || StringUtils.isBlank((CharSequence)attrValue.toString()) ? "&nbsp;" : ((decorator = this.decoratorService.getDecorator(attrValue)) != null ? decorator.toString(attrValue) : attrValue.toString());
        return result;
    }

    public String getTooltip(MailField field, Email email) {
        String tooltipText = null;
        switch (4.$SwitchMap$com$franciaflex$faxtomail$persistence$entities$MailField[field.ordinal()]) {
            case 15: {
                ArrayList<String> ranges = new ArrayList<String>();
                List rangeRows = email.getRangeRow();
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer qty = rangeRow.getProductQuantity();
                        if (qty == null || qty <= 0) continue;
                        ranges.add(rangeRow.getRange().getLabel() + " : " + qty);
                    }
                }
                if (ranges.isEmpty()) break;
                tooltipText = StringUtils.join(ranges, (String)"\n");
                break;
            }
            case 16: {
                ArrayList<String> ranges = new ArrayList<String>();
                List rangeRows = email.getRangeRow();
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer qty = rangeRow.getSavQuantity();
                        if (qty == null || qty <= 0) continue;
                        ranges.add(rangeRow.getRange().getLabel() + " : " + qty);
                    }
                }
                if (ranges.isEmpty()) break;
                tooltipText = StringUtils.join(ranges, (String)"\n");
                break;
            }
            case 17: {
                ArrayList<String> ranges = new ArrayList<String>();
                List rangeRows = email.getRangeRow();
                if (rangeRows != null) {
                    for (RangeRow rangeRow : rangeRows) {
                        Integer qty = rangeRow.getQuotationQuantity();
                        if (qty == null || qty <= 0) continue;
                        ranges.add(rangeRow.getRange().getLabel() + " : " + qty);
                    }
                }
                if (ranges.isEmpty()) break;
                tooltipText = StringUtils.join(ranges, (String)"\n");
                break;
            }
            case 22: {
                List replies = email.getReplies();
                if (!CollectionUtils.isNotEmpty((Collection)replies)) break;
                Decorator decorator = this.decoratorService.getDecoratorByType(Reply.class);
                List replyNames = Lists.transform((List)replies, (Function)new /* Unavailable Anonymous Inner Class!! */);
                tooltipText = StringUtils.join((Iterable)replyNames, (String)"\n");
                break;
            }
            case 23: {
                Collection attachments = email.getAttachment();
                if (!CollectionUtils.isNotEmpty((Collection)attachments)) break;
                Decorator decorator = this.decoratorService.getDecoratorByType(Attachment.class);
                Collection attachmentNames = Collections2.transform((Collection)attachments, (Function)new /* Unavailable Anonymous Inner Class!! */);
                tooltipText = StringUtils.join((Iterable)attachmentNames, (String)"\n");
                break;
            }
            case 24: {
                Set groupEmails;
                EmailGroup emailGroup = email.getEmailGroup();
                ArrayList<Email> emails = new ArrayList<Email>();
                if (emailGroup != null && CollectionUtils.isNotEmpty((Collection)(groupEmails = emailGroup.getEmail()))) {
                    emails.addAll(groupEmails);
                }
                if (emails.isEmpty()) {
                    emails.add(email);
                }
                Collection emailTitles = Collections2.transform(emails, (Function)new /* Unavailable Anonymous Inner Class!! */);
                tooltipText = StringUtils.join((Iterable)emailTitles, (String)"\n");
                break;
            }
            default: {
                tooltipText = this.getAttr(field, email);
            }
        }
        if (tooltipText == null) {
            tooltipText = "&nbsp;";
        }
        return tooltipText;
    }
}

