/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.FontProvider;

final class FileSystemFontProvider
extends FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final Map<String, File> ttfFontFiles = new HashMap<String, File>();
    private final Map<String, File> cffFontFiles = new HashMap<String, File>();
    private final Map<String, File> type1FontFiles = new HashMap<String, File>();
    private final Map<String, TrueTypeFont> ttfFonts = new HashMap<String, TrueTypeFont>();
    private final Map<String, CFFFont> cffFonts = new HashMap<String, CFFFont>();
    private final Map<String, Type1Font> type1Fonts = new HashMap<String, Type1Font>();

    FileSystemFontProvider() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Will search the local system for fonts");
        }
        int count = 0;
        FontFileFinder fontFileFinder = new FontFileFinder();
        List fonts = fontFileFinder.find();
        for (URI font : fonts) {
            ++count;
            File fontFile = new File(font);
            try {
                if (fontFile.getPath().toLowerCase().endsWith(".ttf") || fontFile.getPath().toLowerCase().endsWith(".otf")) {
                    this.addTrueTypeFont(fontFile);
                    continue;
                }
                if (fontFile.getPath().toLowerCase().endsWith(".ttc") || fontFile.getPath().toLowerCase().endsWith(".otc")) {
                    this.addTrueTypeCollection(fontFile);
                    continue;
                }
                if (!fontFile.getPath().toLowerCase().endsWith(".pfb")) continue;
                this.addType1Font(fontFile);
            }
            catch (IOException e) {
                LOG.error((Object)("Error parsing font " + fontFile.getPath()), (Throwable)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + count + " fonts on the local system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeCollection(File ttcFile) throws IOException {
        TrueTypeCollection ttc = null;
        try {
            ttc = new TrueTypeCollection(ttcFile);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                this.addTrueTypeFontImpl(ttf, ttcFile);
            }
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + ttcFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + ttcFile), (Throwable)e);
        }
        finally {
            if (ttc != null) {
                ttc.close();
            }
        }
    }

    private void addTrueTypeFont(File ttfFile) throws IOException {
        TTFParser ttfParser = new TTFParser(false, true);
        try {
            TrueTypeFont ttf = ttfParser.parse(ttfFile);
            this.addTrueTypeFontImpl(ttf, ttfFile);
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + ttfFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + ttfFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTrueTypeFontImpl(TrueTypeFont ttf, File file) throws IOException {
        try {
            NamingTable nameTable = null;
            if (ttf != null) {
                nameTable = ttf.getNaming();
            }
            if (nameTable == null) {
                LOG.warn((Object)("Missing 'name' table in font " + file));
            } else if (nameTable.getPostScriptName() != null) {
                String format;
                String psName = nameTable.getPostScriptName();
                if (ttf.getTableMap().get("CFF ") != null) {
                    format = "OTF";
                    this.cffFontFiles.putAll(this.toMap(this.getNames(ttf), file));
                } else {
                    format = "TTF";
                    this.ttfFontFiles.putAll(this.toMap(this.getNames(ttf), file));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(format + ": '" + psName + "' / '" + nameTable.getFontFamily() + "' / '" + nameTable.getFontSubFamily() + "'"));
                }
            } else {
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + file));
            }
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        FileInputStream input = new FileInputStream(pfbFile);
        try {
            Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
            String psName = type1.getFontName();
            this.type1FontFiles.putAll(this.toMap(this.getNames(type1), pfbFile));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + psName + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        finally {
            ((InputStream)input).close();
        }
    }

    @Override
    public synchronized TrueTypeFont getTrueTypeFont(String postScriptName) {
        TrueTypeFont ttf = this.ttfFonts.get(postScriptName);
        if (ttf != null) {
            return ttf;
        }
        File file = this.ttfFontFiles.get(postScriptName);
        if (file != null) {
            try {
                ttf = this.readTrueTypeFont(postScriptName, file);
                for (String name : this.getNames(ttf)) {
                    this.ttfFonts.put(name, ttf);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (NullPointerException e) {
                LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            }
        }
        return null;
    }

    private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".ttc")) {
            TrueTypeCollection ttc = new TrueTypeCollection(file);
            for (TrueTypeFont ttf : ttc.getFonts()) {
                if (!ttf.getName().equals(postScriptName)) continue;
                return ttf;
            }
            throw new IOException("Font " + postScriptName + " not found in " + file);
        }
        TTFParser ttfParser = new TTFParser(false, true);
        return ttfParser.parse(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CFFFont getCFFFont(String postScriptName) {
        CFFFont cff = this.cffFonts.get(postScriptName);
        if (cff != null) {
            return cff;
        }
        File file = this.cffFontFiles.get(postScriptName);
        if (file != null) {
            CFFFont cFFFont;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                byte[] bytes = IOUtils.toByteArray(input);
                CFFParser cffParser = new CFFParser();
                cff = (CFFFont)cffParser.parse(bytes).get(0);
                for (String name : this.getNames(cff)) {
                    this.cffFonts.put(name, cff);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                cFFFont = cff;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return cFFFont;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Type1Font getType1Font(String postScriptName) {
        Type1Font type1 = this.type1Fonts.get(postScriptName);
        if (type1 != null) {
            return type1;
        }
        File file = this.type1FontFiles.get(postScriptName);
        if (file != null) {
            Type1Font i$;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                type1 = Type1Font.createWithPFB((InputStream)input);
                for (String name : this.getNames(type1)) {
                    this.type1Fonts.put(name, type1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                i$ = type1;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return i$;
        }
        return null;
    }

    private Map<String, File> toMap(Set<String> names, File file) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (String name : names) {
            map.put(name, file);
        }
        return map;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, File> entry : this.ttfFontFiles.entrySet()) {
            sb.append("TTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.cffFontFiles.entrySet()) {
            sb.append("OTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.type1FontFiles.entrySet()) {
            sb.append("PFB: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        return sb.toString();
    }
}

