/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.beans.AbstractBean;

public class DemandesUIModel
extends AbstractBean {
    public static final String PROPERTY_CURRENT_DEMAND = "currentDemand";
    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";
    public static final String PROPERTY_ARCHIVE_ENABLED = "archiveEnabled";
    public static final String PROPERTY_GROUP_ENABLED = "groupEnabled";
    public static final String PROPERTY_PRINT_ENABLED = "printEnabled";
    public static final String PROPERTY_REPLY_ENABLED = "replyEnabled";
    protected boolean transmitEnabled;
    protected boolean archiveEnabled;
    protected boolean groupEnabled;
    protected boolean printEnabled;
    protected boolean replyEnabled;
    protected List<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();
    protected List<DemandsListener> listeners = new ArrayList<DemandsListener>();
    protected int currentIndex = -1;

    public boolean isTransmitEnabled() {
        return this.transmitEnabled;
    }

    public void setTransmitEnabled(boolean transmitEnabled) {
        Boolean oldValue = this.isTransmitEnabled();
        this.transmitEnabled = transmitEnabled;
        this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldValue, transmitEnabled);
    }

    public boolean isArchiveEnabled() {
        return this.archiveEnabled;
    }

    public void setArchiveEnabled(boolean archiveEnabled) {
        Boolean oldValue = this.isArchiveEnabled();
        this.archiveEnabled = archiveEnabled;
        this.firePropertyChange(PROPERTY_ARCHIVE_ENABLED, oldValue, archiveEnabled);
    }

    public boolean isGroupEnabled() {
        return this.groupEnabled;
    }

    public void setGroupEnabled(boolean groupEnabled) {
        Boolean oldValue = this.isGroupEnabled();
        this.groupEnabled = groupEnabled;
        this.firePropertyChange(PROPERTY_GROUP_ENABLED, oldValue, groupEnabled);
    }

    public boolean isPrintEnabled() {
        return this.printEnabled;
    }

    public void setPrintEnabled(boolean printEnabled) {
        Boolean oldValue = this.isPrintEnabled();
        this.printEnabled = printEnabled;
        this.firePropertyChange(PROPERTY_PRINT_ENABLED, oldValue, printEnabled);
    }

    public boolean isReplyEnabled() {
        return this.replyEnabled;
    }

    public void setReplyEnabled(boolean replyEnabled) {
        Boolean oldValue = this.isReplyEnabled();
        this.replyEnabled = replyEnabled;
        this.firePropertyChange(PROPERTY_REPLY_ENABLED, oldValue, replyEnabled);
    }

    protected List<DemandeUIModel> getDemands() {
        return this.demands;
    }

    public void addDemand(DemandeUIModel demand) {
        boolean added;
        boolean bl = added = !this.demands.contains(demand);
        if (added) {
            this.demands.add(demand);
        }
        int index = this.demands.indexOf(demand);
        this.fireDemandAdded(demand, index, added);
    }

    public void removeDemand(int i) {
        DemandeUIModel demand = this.demands.get(i);
        this.demands.remove(i);
        this.fireDemandRemoved(demand, i);
    }

    public boolean containsDemand(DemandeUIModel demand) {
        return this.demands.contains(demand);
    }

    public void addDemandsListener(DemandsListener listener) {
        this.listeners.add(listener);
    }

    public void removeDemandsListener(DemandsListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDemandAdded(DemandeUIModel demand, int index, boolean added) {
        for (DemandsListener listener : this.listeners) {
            listener.onDemandAdded(demand, index, added);
        }
    }

    protected void fireDemandRemoved(DemandeUIModel demand, int index) {
        for (DemandsListener listener : this.listeners) {
            listener.onDemandRemoved(demand, index);
        }
    }

    public DemandeUIModel getCurrentDemand() {
        int currentIndex = this.getCurrentIndex();
        if (currentIndex < 0 || currentIndex >= this.demands.size()) {
            return null;
        }
        return this.demands.get(currentIndex);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        DemandeUIModel oldValue = this.getCurrentDemand();
        this.currentIndex = currentIndex;
        DemandeUIModel newValue = this.getCurrentDemand();
        this.firePropertyChange(PROPERTY_CURRENT_DEMAND, oldValue, newValue);
    }

    public static interface DemandsListener {
        public void onDemandAdded(DemandeUIModel var1, int var2, boolean var3);

        public void onDemandRemoved(DemandeUIModel var1, int var2);
    }
}

