/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentModelAware;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class AttachmentEditorUIModel
extends AbstractFaxToMailBeanUIModel<AttachmentModelAware, AttachmentEditorUIModel> {
    public static final String PROPERTY_EDITABLE = "editable";
    protected boolean editable = true;
    protected final List<Attachment> attachments = new ArrayList<Attachment>();
    protected List<AttachmentListener> openingListeners = new ArrayList<AttachmentListener>();
    protected static Binder<AttachmentEditorUIModel, AttachmentModelAware> toBeanBinder = BinderFactory.newBinder(AttachmentEditorUIModel.class, AttachmentModelAware.class);
    protected static Binder<AttachmentModelAware, AttachmentEditorUIModel> fromBeanBinder = BinderFactory.newBinder(AttachmentModelAware.class, AttachmentEditorUIModel.class);

    protected AttachmentEditorUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public List<Attachment> getAttachment() {
        return this.attachments;
    }

    public void addAllAttachment(List<Attachment> attachments) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.addAll(attachments);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void addAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.add(attachment);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void removeAttachment(Attachment attachment) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.remove(attachment);
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    public void setAttachment(List<Attachment> attachments) {
        ArrayList<Attachment> oldValue = new ArrayList<Attachment>(this.getAttachment());
        this.attachments.clear();
        if (attachments != null) {
            this.attachments.addAll(attachments);
        }
        this.firePropertyChange("attachment", oldValue, this.attachments);
    }

    @Override
    protected AttachmentModelAware newEntity() {
        return null;
    }

    public void addAttachmentListener(AttachmentListener listener) {
        this.openingListeners.add(listener);
    }

    public void removeAttachmentListener(AttachmentListener listener) {
        this.openingListeners.remove(listener);
    }

    public void fireAttachmentOpened(Attachment attachment, boolean original) {
        for (AttachmentListener listener : this.openingListeners) {
            listener.onAttachmentOpened(attachment, original);
        }
    }

    public void fireAttachmentEdited(Attachment attachment) {
        for (AttachmentListener listener : this.openingListeners) {
            listener.onAttachmentEdited(attachment);
        }
    }

    public static interface AttachmentListener {
        public void onAttachmentOpened(Attachment var1, boolean var2);

        public void onAttachmentEdited(Attachment var1);
    }
}

