/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaPersistenceContext;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.services.FaxToMailService;
import com.franciaflex.faxtomail.services.FaxToMailServiceFactory;
import com.franciaflex.faxtomail.services.FaxToMailServiceInvocationHandler;
import com.franciaflex.faxtomail.services.service.ClientService;
import com.franciaflex.faxtomail.services.service.ConfigurationService;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.services.service.LdapService;
import com.franciaflex.faxtomail.services.service.LdapServiceImpl;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.services.service.ValidationService;
import com.franciaflex.faxtomail.services.service.ldap.LdapServiceMock;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class FaxToMailServiceContext
implements Closeable {
    private static final Log log = LogFactory.getLog(FaxToMailServiceContext.class);
    protected FaxToMailServiceContext delegateServiceContext;
    protected FaxToMailConfiguration applicationConfig;
    protected FaxToMailTopiaApplicationContext topiaApplicationContext;
    protected FaxToMailTopiaPersistenceContext persistenceContext;
    protected FaxToMailServiceFactory serviceFactory;

    public static FaxToMailServiceContext newServiceContext(FaxToMailTopiaApplicationContext applicationContext) {
        return new FaxToMailServiceContext(applicationContext, (FaxToMailServiceFactory)new FaxToMailProxiedServiceFactory());
    }

    public static FaxToMailServiceContext newDirectServiceContext(FaxToMailTopiaApplicationContext applicationContext) {
        return new FaxToMailServiceContext(applicationContext, (FaxToMailServiceFactory)new FaxToMailDefaultServiceFactory());
    }

    public static FaxToMailServiceContext newDirectServiceContext(FaxToMailTopiaPersistenceContext persistenceContext) {
        return new FaxToMailServiceContext(persistenceContext, (FaxToMailServiceFactory)new FaxToMailDefaultServiceFactory());
    }

    private FaxToMailServiceContext(FaxToMailTopiaApplicationContext topiaApplicationContext, FaxToMailServiceFactory serviceFactory) {
        Preconditions.checkNotNull((Object)topiaApplicationContext, (Object)"Cannot create an ServiceContext without an ApplicationContext");
        Preconditions.checkNotNull((Object)serviceFactory, (Object)"Cannot create an ServiceContext without a ServiceFactory");
        this.topiaApplicationContext = topiaApplicationContext;
        this.serviceFactory = serviceFactory;
        this.serviceFactory.setServiceContext(this);
    }

    private FaxToMailServiceContext(FaxToMailTopiaPersistenceContext persistenceContext, FaxToMailServiceFactory serviceFactory) {
        this.persistenceContext = persistenceContext;
        this.serviceFactory = serviceFactory;
        this.serviceFactory.setServiceContext(this);
    }

    private FaxToMailServiceContext(FaxToMailServiceContext delegateServiceContext, FaxToMailServiceFactory serviceFactory) {
        this.delegateServiceContext = delegateServiceContext;
        this.serviceFactory = serviceFactory;
        this.serviceFactory.setServiceContext(this);
    }

    public FaxToMailConfiguration getApplicationConfig() {
        if (this.delegateServiceContext != null) {
            return this.delegateServiceContext.getApplicationConfig();
        }
        return this.applicationConfig;
    }

    public FaxToMailTopiaPersistenceContext getPersistenceContext() {
        if (this.delegateServiceContext != null) {
            return this.delegateServiceContext.getPersistenceContext();
        }
        if (this.persistenceContext == null) {
            this.persistenceContext = this.topiaApplicationContext.newPersistenceContext();
        }
        return this.persistenceContext;
    }

    public void setApplicationConfig(FaxToMailConfiguration applicationConfig) {
        if (this.delegateServiceContext != null) {
            this.delegateServiceContext.setApplicationConfig(applicationConfig);
        } else {
            this.applicationConfig = applicationConfig;
        }
    }

    public <E extends FaxToMailService> E newService(Class<E> serviceInterfaceClass) {
        return this.serviceFactory.newService(serviceInterfaceClass);
    }

    public Date getNow() {
        Date now = new Date();
        return now;
    }

    public DecoratorService getDecoratorService() {
        return this.newService(DecoratorService.class);
    }

    public ValidationService getValidationService() {
        return this.newService(ValidationService.class);
    }

    public MailFolderService getMailFolderService() {
        return this.newService(MailFolderService.class);
    }

    public UserService getUserService() {
        return this.newService(UserService.class);
    }

    public LdapService getLdapService() {
        return this.newService(LdapService.class);
    }

    public EmailService getEmailService() {
        return this.newService(EmailService.class);
    }

    public ReferentielService getReferentielService() {
        return this.newService(ReferentielService.class);
    }

    public ConfigurationService getConfigurationService() {
        return this.newService(ConfigurationService.class);
    }

    public InitFaxToMailService getInitFaxToMailService() {
        return this.newService(InitFaxToMailService.class);
    }

    public ClientService getClientService() {
        return this.newService(ClientService.class);
    }

    @Override
    public void close() throws IOException {
        if (this.persistenceContext != null) {
            if (Boolean.getBoolean("hibernate.generate_statistics") && log.isInfoEnabled()) {
                log.info((Object)this.persistenceContext.getHibernateSupport().getHibernateFactory().getStatistics());
            }
            this.persistenceContext.close();
            this.persistenceContext = null;
        }
    }

    public static class FaxToMailProxiedServiceFactory
    implements FaxToMailServiceFactory {
        protected FaxToMailDefaultServiceFactory defaultServiceFactory;
        protected FaxToMailServiceContext subServiceContext;
        protected FaxToMailServiceContext serviceContext;

        @Override
        public void setServiceContext(FaxToMailServiceContext serviceContext) {
            this.serviceContext = serviceContext;
        }

        @Override
        public <E extends FaxToMailService> E newService(Class<E> serviceInterfaceClass) {
            if (this.defaultServiceFactory == null) {
                this.defaultServiceFactory = new FaxToMailDefaultServiceFactory();
                this.subServiceContext = new FaxToMailServiceContext(this.serviceContext, this.defaultServiceFactory);
                this.defaultServiceFactory.setServiceContext(this.subServiceContext);
            }
            E realService = this.defaultServiceFactory.newService(serviceInterfaceClass);
            FaxToMailService service = (FaxToMailService)Proxy.newProxyInstance(serviceInterfaceClass.getClassLoader(), new Class[]{serviceInterfaceClass}, (InvocationHandler)new FaxToMailServiceInvocationHandler(realService, this.serviceContext));
            return (E)service;
        }
    }

    public static class FaxToMailDefaultServiceFactory
    implements FaxToMailServiceFactory {
        protected FaxToMailServiceContext serviceContext;

        @Override
        public void setServiceContext(FaxToMailServiceContext serviceContext) {
            this.serviceContext = serviceContext;
        }

        @Override
        public <E extends FaxToMailService> E newService(Class<E> serviceInterfaceClass) {
            FaxToMailService service;
            try {
                Class<Object> serviceImplClass = Class.forName(serviceInterfaceClass.getCanonicalName() + "Impl");
                if (serviceImplClass.equals(LdapServiceImpl.class) && this.serviceContext.getApplicationConfig().isLdapMock()) {
                    serviceImplClass = LdapServiceMock.class;
                }
                Constructor<?> constructor = serviceImplClass.getConstructor(new Class[0]);
                service = (FaxToMailService)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ApplicationTechnicalException("all services must provide a non-argument constructor", (Throwable)e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ApplicationTechnicalException("unable to instantiate service", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ApplicationTechnicalException("unable to find the implementation of the service", (Throwable)e);
            }
            service.setServiceContext(this.serviceContext);
            return (E)service;
        }
    }
}

