package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Mon Sep 07 15:44:54 CEST 2015")
public abstract class GeneratedReplyTopiaDao<E extends Reply> extends AbstractFaxToMailTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Reply.class;
    }

    @Override
    public FaxToMailEntityEnum getTopiaEntityEnum() {
        return FaxToMailEntityEnum.Reply;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(Date sentDate, String subject, String sender, String recipient, ReplyContent replyContent, FaxToMailUser sentBy) {
        return create(Reply.PROPERTY_SENT_DATE, sentDate, Reply.PROPERTY_SUBJECT, subject, Reply.PROPERTY_SENDER, sender, Reply.PROPERTY_RECIPIENT, recipient, Reply.PROPERTY_REPLY_CONTENT, replyContent, Reply.PROPERTY_SENT_BY, sentBy);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSentDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_SENT_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSentDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_SENT_DATE, v);
        return result;
    }

    @Deprecated
    public E findBySentDate(Date v) {
        return forSentDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySentDate(Date v) {
        return forSentDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSubjectIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_SUBJECT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSubjectEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_SUBJECT, v);
        return result;
    }

    @Deprecated
    public E findBySubject(String v) {
        return forSubjectEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySubject(String v) {
        return forSubjectEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSenderIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_SENDER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSenderEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_SENDER, v);
        return result;
    }

    @Deprecated
    public E findBySender(String v) {
        return forSenderEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySender(String v) {
        return forSenderEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRecipientIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_RECIPIENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRecipientEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_RECIPIENT, v);
        return result;
    }

    @Deprecated
    public E findByRecipient(String v) {
        return forRecipientEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRecipient(String v) {
        return forRecipientEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReplyContentIn(Collection<ReplyContent> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_REPLY_CONTENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forReplyContentEquals(ReplyContent v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_REPLY_CONTENT, v);
        return result;
    }

    @Deprecated
    public E findByReplyContent(ReplyContent v) {
        return forReplyContentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByReplyContent(ReplyContent v) {
        return forReplyContentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSentByIn(Collection<FaxToMailUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Reply.PROPERTY_SENT_BY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSentByEquals(FaxToMailUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Reply.PROPERTY_SENT_BY, v);
        return result;
    }

    @Deprecated
    public E findBySentBy(FaxToMailUser v) {
        return forSentByEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySentBy(FaxToMailUser v) {
        return forSentByEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Email.class) {
            EmailTopiaDao dao =
                topiaDaoSupplier.getDao(Email.class, EmailTopiaDao.class);
            tmp = dao.forRepliesContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Email.class, entity);
        if (!list.isEmpty()) {
            result.put(Email.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(entity.getReplyContent());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedReplyTopiaDao<E extends Reply>
