/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.support;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;

public class AggregatedFolderPathResolver {
    private File cssDestinationFolder;
    private File buildDirectory;
    private File buildFinalName;
    private File destinationFolder;
    private String contextFoldersAsCSV;
    private Log log;

    public String resolve() {
        Validate.notNull((Object)this.buildDirectory, (String)"Build directory cannot be null!", (Object[])new Object[0]);
        Validate.notNull((Object)this.log, (String)"Logger cannot be null!", (Object[])new Object[0]);
        String result = null;
        File cssTargetFolder = this.cssDestinationFolder == null ? this.destinationFolder : this.cssDestinationFolder;
        File rootFolder = null;
        Validate.notNull((Object)cssTargetFolder, (String)"cssTargetFolder cannot be null!", (Object[])new Object[0]);
        if (this.buildFinalName != null && cssTargetFolder.getPath().startsWith(this.buildFinalName.getPath())) {
            rootFolder = this.buildFinalName;
        } else if (cssTargetFolder.getPath().startsWith(this.buildDirectory.getPath())) {
            rootFolder = this.buildDirectory;
        } else {
            for (String contextFolder : this.getContextFolders()) {
                if (!cssTargetFolder.getPath().startsWith(contextFolder)) continue;
                rootFolder = new File(contextFolder);
                break;
            }
        }
        this.log.debug((CharSequence)("buildDirectory: " + this.buildDirectory));
        this.log.debug((CharSequence)("contextFolders: " + this.contextFoldersAsCSV));
        this.log.debug((CharSequence)("cssTargetFolder: " + cssTargetFolder));
        this.log.debug((CharSequence)("rootFolder: " + rootFolder));
        if (rootFolder != null) {
            result = StringUtils.removeStart((String)cssTargetFolder.getPath(), (String)rootFolder.getPath());
        }
        this.log.debug((CharSequence)("computedAggregatedFolderPath: " + result));
        return result;
    }

    private String[] getContextFolders() {
        StandaloneContext context = new StandaloneContext();
        context.setContextFoldersAsCSV(this.contextFoldersAsCSV);
        return context.getContextFolders();
    }

    public AggregatedFolderPathResolver setCssDestinationFolder(File cssDestinationFolder) {
        this.cssDestinationFolder = cssDestinationFolder;
        return this;
    }

    public AggregatedFolderPathResolver setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
        return this;
    }

    public AggregatedFolderPathResolver setBuildFinalName(File buildFinalName) {
        this.buildFinalName = buildFinalName;
        return this;
    }

    public AggregatedFolderPathResolver setDestinationFolder(File destinationFolder) {
        this.destinationFolder = destinationFolder;
        return this;
    }

    public AggregatedFolderPathResolver setContextFoldersAsCSV(String contextFoldersAsCSV) {
        this.contextFoldersAsCSV = contextFoldersAsCSV;
        return this;
    }

    public AggregatedFolderPathResolver setLog(Log log) {
        this.log = log;
        return this;
    }
}

