/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.support;

import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.logging.Log;
import ro.isdc.wro.model.resource.Resource;

public class ProgressIndicator {
    private static final int DEFAULT_TIMEOUT_DELAY = 5000;
    private int totalResources = 0;
    private int totalResourcesWithErrors = 0;
    private int totalFoundErrors = 0;
    private long timeoutDelay = 5000L;
    private long lastInvocationTimestamp;
    private final Log log;

    public ProgressIndicator(Log log) {
        this.log = log;
        this.updateLastInvocation();
    }

    private void updateLastInvocation() {
        this.lastInvocationTimestamp = System.currentTimeMillis();
    }

    public void reset() {
        this.totalFoundErrors = 0;
        this.totalResources = 0;
        this.totalResourcesWithErrors = 0;
    }

    public void logSummary() {
        String message = this.totalFoundErrors == 0 ? "No lint errors found." : String.format("Found %s errors in %s files.", this.totalFoundErrors, this.totalResourcesWithErrors);
        this.log.info((CharSequence)"----------------------------------------");
        this.log.info((CharSequence)String.format("Total resources: %s", this.totalResources));
        this.log.info((CharSequence)message);
        this.log.info((CharSequence)"----------------------------------------\n");
    }

    public void onProcessingResource(Resource resource) {
        ++this.totalResources;
        this.log.debug((CharSequence)("processing resource: " + resource.getUri()));
        if (this.isLogRequired()) {
            this.log.info((CharSequence)("Resources processed: " + this.getTotalResources() + ". Last processed: " + resource.getUri()));
        }
        this.updateLastInvocation();
    }

    private boolean isLogRequired() {
        return System.currentTimeMillis() - this.lastInvocationTimestamp > this.timeoutDelay;
    }

    public void addFoundErrors(int errorsToAdd) {
        Validate.isTrue((errorsToAdd > 0 ? 1 : 0) != 0, (String)"Cannot add negative number of errors", (Object[])new Object[0]);
        ++this.totalResourcesWithErrors;
        this.totalFoundErrors += errorsToAdd;
    }

    public final int getTotalFoundErrors() {
        return this.totalFoundErrors;
    }

    final int getTotalResources() {
        return this.totalResources;
    }

    final int getTotalResourcesWithErrors() {
        return this.totalResourcesWithErrors;
    }

    final void setTimeoutDelay(long timeoutDelay) {
        this.timeoutDelay = timeoutDelay;
    }
}

