/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.css.CssLintProcessor;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractLinterMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssLintMojo
extends AbstractLinterMojo<CssLintError> {
    private File reportFile;
    private String reportFormat = ReportXmlFormatter.FormatterType.LINT.getFormat();

    @Override
    protected ResourcePreProcessor createResourceProcessor() {
        CssLintProcessor processor = new CssLintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                if (resource != null) {
                    CssLintMojo.this.getLog().info((CharSequence)("processing resource: " + resource.getUri()));
                }
                super.process(resource, reader, (Writer)new StringWriter());
            }

            protected void onException(WroRuntimeException e) {
                CssLintMojo.this.onException((Exception)e);
            }

            protected void onCssLintException(CssLintException e, Resource resource) {
                CssLintMojo.this.getLog().error((CharSequence)(e.getErrors().size() + " errors found while processing resource: " + resource.getUri() + " Errors are: " + e.getErrors()));
                CssLintMojo.this.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (!CssLintMojo.this.isFailNever()) {
                    throw new WroRuntimeException("Errors found when validating resource: " + resource);
                }
            }
        }.setOptionsAsString(this.getOptions());
        return processor;
    }

    @Override
    protected ReportXmlFormatter createXmlFormatter(LintReport<CssLintError> lintReport, ReportXmlFormatter.FormatterType type) {
        return ReportXmlFormatter.createForCssLintError(lintReport, (ReportXmlFormatter.FormatterType)type);
    }

    @Override
    protected File getReportFile() {
        return this.reportFile;
    }

    @Override
    protected String getReportFormat() {
        return this.reportFormat;
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    void onException(Exception e) {
    }
}

