/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.fn;

import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Box;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Row;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.ext.Paginal;

public class ZulFns {
    protected ZulFns() {
    }

    public static final String getColAttrs(Row row, int index) {
        return row.getChildAttrs(index);
    }

    public static final String getBoxChildInnerAttrs(Component child) {
        return ((Box)child.getParent()).getChildInnerAttrs(child);
    }

    public static final String getBoxChildOuterAttrs(Component child) {
        return ((Box)child.getParent()).getChildOuterAttrs(child);
    }

    public static final void setStripeClass(Component child) {
        Component parent = child.getParent();
        if (!(!child.isVisible() || child instanceof Listgroup || child instanceof Group || child instanceof Groupfoot || child instanceof Listgroupfoot)) {
            String odd = (String)parent.getAttribute("org.zkoss.zul.StripeState");
            if (odd == null || !odd.equals("")) {
                parent.setAttribute("org.zkoss.zul.StripeState", (Object)"");
            } else if (parent instanceof Listbox) {
                parent.setAttribute("org.zkoss.zul.StripeState", (Object)((Listbox)parent).getOddRowSclass());
            } else {
                parent.setAttribute("org.zkoss.zul.StripeState", (Object)((Grid)parent.getParent()).getOddRowSclass());
            }
        }
    }

    public static final void resetStripeClass(Component parent) {
        parent.removeAttribute("org.zkoss.zul.StripeState");
    }

    public static final boolean shallVisitTree(Tree tree, Component child) {
        boolean shoulbBeVisited;
        Treeitem item = (Treeitem)child;
        int count = item.isOpen() && item.getTreechildren() != null ? item.getTreechildren().getVisibleItemCount() : 0;
        Integer visited = (Integer)tree.getAttribute("org.zkoss.zul.VisitedItemCount");
        Paginal pgi = tree.getPaginal();
        int ofs = pgi.getActivePage() * pgi.getPageSize();
        int visit = visited != null ? visited + 1 : 1;
        boolean bl = shoulbBeVisited = ofs < visit + count;
        visited = visited == null ? new Integer(shoulbBeVisited ? 1 : count + 1) : new Integer(visited + (shoulbBeVisited ? 1 : count + 1));
        Integer total = (Integer)tree.getAttribute("org.zkoss.zul.VisitedItemTotal");
        total = total == null ? new Integer(count + 1) : new Integer(total + count + 1);
        tree.setAttribute("org.zkoss.zul.VisitedItemCount", visited);
        tree.setAttribute("org.zkoss.zul.VisitedItemTotal", total);
        return shoulbBeVisited;
    }

    public static final boolean shallRenderTree(Tree tree) {
        Integer visited = (Integer)tree.getAttribute("org.zkoss.zul.VisitedItemCount");
        Paginal pgi = tree.getPaginal();
        int ofs = pgi.getActivePage() * pgi.getPageSize();
        if (ofs < visited) {
            Integer renderedCount = (Integer)tree.getAttribute("org.zkoss.zul.RenderedItemCount");
            renderedCount = renderedCount == null ? new Integer(1) : new Integer(renderedCount + 1);
            tree.setAttribute("org.zkoss.zul.RenderedItemCount", renderedCount);
            return true;
        }
        return false;
    }

    public static final void clearTreeRenderInfo(Tree tree) {
        tree.removeAttribute("org.zkoss.zul.RenderedItemCount");
        tree.removeAttribute("org.zkoss.zul.VisitedItemCount");
        tree.removeAttribute("org.zkoss.zul.VisitedItemTotal");
    }
}

