/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;

public abstract class XulElement
extends HtmlBasedComponent {
    private String _popup;
    private String _ctx;
    private String _tooltip;
    private String _action;
    private Map _actmap;

    public String getContext() {
        return this._ctx;
    }

    public void setContext(String context) {
        if (!Objects.equals((Object)this._ctx, (Object)context)) {
            this._ctx = context;
            this.smartUpdate("z:ctx", this._ctx);
        }
    }

    public String getPopup() {
        return this._popup;
    }

    public void setPopup(String popup) {
        if (!Objects.equals((Object)this._popup, (Object)popup)) {
            this._popup = popup;
            this.smartUpdate("z:pop", this._popup);
        }
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public void setTooltip(String tooltip) {
        if (!Objects.equals((Object)this._tooltip, (Object)tooltip)) {
            this._tooltip = tooltip;
            this.smartUpdate("z:tip", this._tooltip);
        }
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        if (action != null && action.length() == 0) {
            action = null;
        }
        if (!Objects.equals((Object)this._action, (Object)action)) {
            Iterator it;
            Map old = this._actmap;
            this._actmap = action != null ? XulElement.parseAction(action) : null;
            this._action = action;
            if (this._actmap != null) {
                it = this._actmap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    String actnm = (String)me.getKey();
                    String actval = (String)me.getValue();
                    if (old != null && Objects.equals((Object)actval, old.get(actnm))) continue;
                    this.smartUpdate(actnm, this.toJavaScript(actval));
                }
            }
            if (old != null) {
                it = old.keySet().iterator();
                while (it.hasNext()) {
                    String actnm = (String)((Object)it.next());
                    if (this._actmap != null && this._actmap.containsKey(actnm)) continue;
                    this.smartUpdate(actnm, null);
                }
            }
        }
    }

    private static final Map parseAction(String action) {
        HashMap<String, String> map = new HashMap<String, String>();
        int k = action.indexOf(58);
        if (k < 0) {
            throw new WrongValueException("Unknown action: " + action);
        }
        int j = 0;
        int len = action.length();
        while (true) {
            String val;
            String actnm;
            if ((actnm = action.substring(j, k).trim()).length() == 0) {
                throw new WrongValueException("Unknown action: " + action);
            }
            int l = len;
            j = ++k;
            while (k < len) {
                char c2;
                char cc = action.charAt(k);
                if (cc == '\'' || cc == '\"') {
                    while (++k < len && (c2 = action.charAt(k)) != cc) {
                        if (c2 != '\\') continue;
                        ++k;
                    }
                } else if (cc == ';') {
                    for (l = Strings.skipWhitespaces((String)action, (int)(k + 1)); l < len && (c2 = action.charAt(l)) >= 'a' && c2 <= 'z'; ++l) {
                    }
                    if ((l = Strings.skipWhitespaces((String)action, (int)l)) >= len || action.charAt(l) == ':') {
                        ++k;
                        break;
                    }
                }
                ++k;
            }
            if ((val = action.substring(j, k > len ? len : k).trim()).length() > 0) {
                map.put(actnm, val);
            }
            if (l >= len) {
                return map;
            }
            j = k;
            k = l;
        }
    }

    private final String toJavaScript(String action) {
        if (action == null) {
            return null;
        }
        StringBuffer sb = null;
        char quote = '\u0000';
        int len = action.length();
        for (int j = 0; j < len; ++j) {
            char cc = action.charAt(j);
            if (quote == '\u0000' && (cc == '_' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z')) {
                int k;
                block10: {
                    for (k = j + 1; k < len && ((cc = action.charAt(k)) == '_' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9'); ++k) {
                    }
                    String var = action.substring(j, k);
                    try {
                        Component fellow = this.getFellow(var);
                        if (sb == null) {
                            sb = new StringBuffer(len + 16).append(action.substring(0, j));
                        }
                        sb.append('\'').append(fellow.getUuid()).append('\'');
                    }
                    catch (ComponentNotFoundException ex) {
                        if (sb == null) break block10;
                        sb.append(var);
                    }
                }
                j = k - 1;
                continue;
            }
            if (sb != null) {
                sb.append(cc);
            }
            if (quote != '\u0000') {
                if (cc == quote) {
                    quote = '\u0000';
                    continue;
                }
                if (cc != '\\' || ++j >= len || sb == null) continue;
                sb.append(action.charAt(j));
                continue;
            }
            if (cc != '\'' && cc != '\"') continue;
            quote = cc;
        }
        return sb != null ? sb.toString() : action;
    }

    protected String getAllOnClickAttrs(boolean ignoreOnClick) {
        StringBuffer sb = null;
        if (!ignoreOnClick) {
            sb = this.appendAsapAttr(sb, "onClick");
        }
        sb = this.appendAsapAttr(sb, "onDoubleClick");
        return (sb = this.appendAsapAttr(sb, "onRightClick")) != null ? sb.toString() : null;
    }

    public Object clone() {
        XulElement clone = (XulElement)((Object)super.clone());
        if (clone._actmap != null) {
            clone._actmap = new HashMap(clone._actmap);
        }
        return clone;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String ctx = this.getContext();
        String popup = this.getPopup();
        String tip = this.getTooltip();
        if (ctx == null && tip == null && popup == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:ctx", (String)ctx);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:pop", (String)popup);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:tip", (String)tip);
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        if (this._actmap == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(100).append(attrs);
        Iterator it = this._actmap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            HTMLs.appendAttribute((StringBuffer)sb, (String)((String)me.getKey()), (String)this.toJavaScript((String)me.getValue()));
        }
        return sb.toString();
    }
}

