/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataItem;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Area;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.Chart;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.HiLoModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.impl.ChartEngine;

public class SimpleChartEngine
implements ChartEngine {
    private static final String DEFAULT_HI_LO_SERIES = "High Low Data";
    private boolean _threeD;
    private String _type;
    private ChartImpl _chartImpl;

    private ChartImpl getChartImpl(Chart chart) {
        if (Objects.equals((Object)chart.getType(), (Object)this._type) && this._threeD == chart.isThreeD()) {
            return this._chartImpl;
        }
        if ("pie".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Pie3d() : new Pie();
        } else if ("ring".equals(chart.getType())) {
            this._chartImpl = new Ring();
        } else if ("bar".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Bar3d() : new Bar();
        } else if ("line".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new Line3d() : new Line();
        } else if ("area".equals(chart.getType())) {
            this._chartImpl = new AreaImpl();
        } else if ("stacked_bar".equals(chart.getType())) {
            this._chartImpl = chart.isThreeD() ? new StackedBar3d() : new StackedBar();
        } else if ("stacked_area".equals(chart.getType())) {
            this._chartImpl = new StackedArea();
        } else if ("waterfall".equals(chart.getType())) {
            this._chartImpl = new Waterfall();
        } else if ("polar".equals(chart.getType())) {
            this._chartImpl = new Polar();
        } else if ("scatter".equals(chart.getType())) {
            this._chartImpl = new Scatter();
        } else if ("time_series".equals(chart.getType())) {
            this._chartImpl = new TimeSeries();
        } else if ("step_area".equals(chart.getType())) {
            this._chartImpl = new StepArea();
        } else if ("step".equals(chart.getType())) {
            this._chartImpl = new Step();
        } else if ("histogram".equals(chart.getType())) {
            this._chartImpl = new Histogram();
        } else if ("candlestick".equals(chart.getType())) {
            this._chartImpl = new Candlestick();
        } else if ("highlow".equals(chart.getType())) {
            this._chartImpl = new Highlow();
        } else {
            throw new UiException("Unsupported chart type yet: " + chart.getType());
        }
        this._threeD = chart.isThreeD();
        this._type = chart.getType();
        return this._chartImpl;
    }

    public byte[] drawChart(Object data) {
        int[] paneRGB;
        Chart chart = (Chart)((Object)data);
        ChartImpl impl = this.getChartImpl(chart);
        JFreeChart jfchart = impl.createChart(chart);
        Plot plot = jfchart.getPlot();
        float alpha = (float)chart.getFgAlpha() / 255.0f;
        plot.setForegroundAlpha(alpha);
        alpha = (float)chart.getBgAlpha() / 255.0f;
        plot.setBackgroundAlpha(alpha);
        int[] bgRGB = chart.getBgRGB();
        if (bgRGB != null) {
            plot.setBackgroundPaint((Paint)new Color(bgRGB[0], bgRGB[1], bgRGB[2], chart.getBgAlpha()));
        }
        if ((paneRGB = chart.getPaneRGB()) != null) {
            jfchart.setBackgroundPaint((Paint)new Color(paneRGB[0], paneRGB[1], paneRGB[2], chart.getPaneAlpha()));
        }
        ChartRenderingInfo jfinfo = new ChartRenderingInfo();
        BufferedImage bi = jfchart.createBufferedImage(chart.getIntWidth(), chart.getIntHeight(), 3, jfinfo);
        chart.getChildren().clear();
        int j = 0;
        String preUrl = null;
        Iterator it = jfinfo.getEntityCollection().getEntities().iterator();
        while (it.hasNext()) {
            ChartEntity ce = (ChartEntity)it.next();
            String url = ce.getURLText();
            if (url != null) {
                if (preUrl == null) {
                    preUrl = url;
                } else if (url.equals(preUrl)) break;
            }
            Area area = new Area();
            area.setParent((Component)chart);
            area.setCoords(ce.getShapeCoords());
            area.setShape(ce.getShapeType());
            area.setId("area_" + chart.getId() + '_' + j++);
            if (chart.isShowTooltiptext() && ce.getToolTipText() != null) {
                area.setTooltiptext(ce.getToolTipText());
            }
            area.setAttribute("url", ce.getURLText());
            impl.render(chart, area, ce);
            if (chart.getAreaListener() == null) continue;
            try {
                chart.getAreaListener().onRender(area, ce);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        chart.removeAttribute("LEGEND_SEQ");
        chart.removeAttribute("TICK_SEQ");
        try {
            return EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    private PieDataset PieModelToPieDataset(PieModel model) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        Iterator it = model.getCategories().iterator();
        while (it.hasNext()) {
            Comparable category = (Comparable)it.next();
            Number value = model.getValue(category);
            dataset.setValue(category, value);
        }
        return dataset;
    }

    private PieDataset CategoryModelToPieDataset(CategoryModel model) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        Comparable defaultSeries = null;
        int max = 0;
        Iterator it = model.getKeys().iterator();
        while (it.hasNext()) {
            List key = (List)it.next();
            Comparable series = (Comparable)key.get(0);
            if (defaultSeries == null) {
                defaultSeries = series;
                max = model.getCategories().size();
            }
            if (!Objects.equals((Object)defaultSeries, (Object)series)) continue;
            Comparable category = (Comparable)key.get(1);
            Number value = model.getValue(series, category);
            dataset.setValue(category, value);
            if (--max != 0) continue;
            break;
        }
        return dataset;
    }

    private CategoryDataset CategoryModelToCategoryDataset(CategoryModel model) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        Iterator it = model.getKeys().iterator();
        while (it.hasNext()) {
            List key = (List)it.next();
            Comparable series = (Comparable)key.get(0);
            Comparable category = (Comparable)key.get(1);
            Number value = model.getValue(series, category);
            dataset.setValue(value, series, category);
        }
        return dataset;
    }

    private XYDataset XYModelToXYDataset(XYModel model) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable series = (Comparable)it.next();
            XYSeries xyser = new XYSeries(series, model.isAutoSort());
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                xyser.add(model.getX(series, j), model.getY(series, j), false);
            }
            dataset.addSeries(xyser);
        }
        return dataset;
    }

    private TableXYDataset XYModelToTableXYDataset(XYModel model) {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        Iterator it = model.getSeries().iterator();
        while (it.hasNext()) {
            Comparable series = (Comparable)it.next();
            XYSeries xyser = new XYSeries(series, false, false);
            int size = model.getDataCount(series);
            for (int j = 0; j < size; ++j) {
                xyser.add(model.getX(series, j), model.getY(series, j), false);
            }
            dataset.addSeries(xyser);
        }
        return dataset;
    }

    private OHLCDataset HiLoModelToOHLCDataset(HiLoModel model) {
        int size = model.getDataCount();
        OHLCDataItem[] items = new OHLCDataItem[size];
        for (int j = 0; j < size; ++j) {
            OHLCDataItem item;
            Date date = model.getDate(j);
            Number open = model.getOpen(j);
            Number high = model.getHigh(j);
            Number low = model.getLow(j);
            Number close = model.getClose(j);
            Number volume = model.getVolume(j);
            items[j] = item = new OHLCDataItem(date, this.doubleValue(open), this.doubleValue(high), this.doubleValue(low), this.doubleValue(close), this.doubleValue(volume));
        }
        Object series = model.getSeries();
        if (series == null) {
            series = DEFAULT_HI_LO_SERIES;
        }
        return new DefaultOHLCDataset((Comparable)series, items);
    }

    private double doubleValue(Number n) {
        return n == null ? 0.0 : n.doubleValue();
    }

    private void decodeLegendInfo(Area area, LegendItemEntity info, Chart chart) {
        if (info == null) {
            return;
        }
        ChartModel model = chart.getModel();
        int seq = (Integer)chart.getAttribute("LEGEND_SEQ");
        if (model instanceof PieModel) {
            Comparable category = ((PieModel)model).getCategory(seq);
            area.setAttribute("category", category);
            area.setAttribute("value", ((PieModel)model).getValue(category));
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(category.toString());
            }
        } else if (model instanceof CategoryModel) {
            Comparable series = ((CategoryModel)model).getSeries(seq);
            area.setAttribute("series", series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        } else if (model instanceof XYModel) {
            Comparable series = ((XYModel)model).getSeries(seq);
            area.setAttribute("series", series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        } else if (model instanceof HiLoModel) {
            Object series = ((HiLoModel)model).getSeries();
            if (series == null) {
                series = DEFAULT_HI_LO_SERIES;
            }
            area.setAttribute("series", series);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(series.toString());
            }
        }
    }

    private void decodeTickLabelInfo(Area area, TickLabelEntity info, Chart chart) {
        if (info == null) {
            return;
        }
        ChartModel model = chart.getModel();
        int seq = (Integer)chart.getAttribute("TICK_SEQ");
        if (model instanceof CategoryModel) {
            Comparable category = ((CategoryModel)model).getCategory(seq);
            area.setAttribute("category", category);
            if (chart.isShowTooltiptext() && info.getToolTipText() == null) {
                area.setTooltiptext(category.toString());
            }
        }
    }

    private void decodePieInfo(Area area, PieSectionEntity info) {
        if (info == null) {
            return;
        }
        PieDataset dataset = info.getDataset();
        Comparable category = info.getSectionKey();
        area.setAttribute("category", category);
        area.setAttribute("value", dataset.getValue(category));
    }

    private void decodeCategoryInfo(Area area, CategoryItemEntity info) {
        if (info == null) {
            return;
        }
        CategoryDataset dataset = info.getDataset();
        int si = info.getSeries();
        Comparable category = (Comparable)info.getCategory();
        Comparable series = dataset.getRowKey(si);
        area.setAttribute("series", series);
        area.setAttribute("category", category);
        area.setAttribute("value", dataset.getValue(series, category));
    }

    private void decodeXYInfo(Area area, XYItemEntity info) {
        if (info == null) {
            return;
        }
        XYDataset dataset = info.getDataset();
        int si = info.getSeriesIndex();
        int ii = info.getItem();
        area.setAttribute("series", dataset.getSeriesKey(si));
        if (dataset instanceof OHLCDataset) {
            OHLCDataset ds = (OHLCDataset)dataset;
            area.setAttribute("date", new Date(ds.getX(si, ii).longValue()));
            area.setAttribute("open", ds.getOpen(si, ii));
            area.setAttribute("high", ds.getHigh(si, ii));
            area.setAttribute("low", ds.getLow(si, ii));
            area.setAttribute("close", ds.getClose(si, ii));
            area.setAttribute("volume", ds.getVolume(si, ii));
        } else {
            area.setAttribute("x", dataset.getX(si, ii));
            area.setAttribute("y", dataset.getY(si, ii));
        }
    }

    private PlotOrientation getOrientation(String orient) {
        return "horizontal".equals(orient) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
    }

    private class Highlow
    extends ChartImpl {
        private Highlow() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof HiLoModel)) {
                throw new UiException("model must be a org.zkoss.zul.HiLoModel");
            }
            return ChartFactory.createHighLowChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (OHLCDataset)SimpleChartEngine.this.HiLoModelToOHLCDataset((HiLoModel)model), (boolean)chart.isShowLegend());
        }
    }

    private class Candlestick
    extends ChartImpl {
        private Candlestick() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof HiLoModel)) {
                throw new UiException("model must be a org.zkoss.zul.HiLoModel");
            }
            return ChartFactory.createCandlestickChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (OHLCDataset)SimpleChartEngine.this.HiLoModelToOHLCDataset((HiLoModel)model), (boolean)chart.isShowLegend());
        }
    }

    private class Histogram
    extends ChartImpl {
        private Histogram() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createHistogram((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (IntervalXYDataset)((IntervalXYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model)), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Step
    extends ChartImpl {
        private Step() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createXYStepChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StepArea
    extends ChartImpl {
        private StepArea() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createXYStepAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class TimeSeries
    extends ChartImpl {
        private TimeSeries() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createTimeSeriesChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Scatter
    extends ChartImpl {
        private Scatter() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createScatterPlot((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Polar
    extends ChartImpl {
        private Polar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof XYModel)) {
                throw new UiException("model must be a org.zkoss.zul.XYModel");
            }
            return ChartFactory.createPolarChart((String)chart.getTitle(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Waterfall
    extends ChartImpl {
        private Waterfall() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createWaterfallChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StackedArea
    extends ChartImpl {
        private StackedArea() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createStackedAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createStackedXYAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (TableXYDataset)SimpleChartEngine.this.XYModelToTableXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class StackedBar3d
    extends StackedBar {
        private StackedBar3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createStackedBarChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class StackedBar
    extends ChartImpl {
        private StackedBar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createStackedBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Line3d
    extends Line {
        private Line3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createLineChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Line
    extends ChartImpl {
        private Line() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createLineChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYLineChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class AreaImpl
    extends ChartImpl {
        private AreaImpl() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYAreaChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (XYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Bar3d
    extends Bar {
        private Bar3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (!(model instanceof CategoryModel)) {
                throw new UiException("model must be a org.zkoss.zul.CategoryModel");
            }
            return ChartFactory.createBarChart3D((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Bar
    extends ChartImpl {
        private Bar() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof CategoryItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeCategoryInfo(area, (CategoryItemEntity)info);
            } else if (info instanceof XYItemEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodeXYInfo(area, (XYItemEntity)info);
            } else if (info instanceof TickLabelEntity) {
                area.setAttribute("entity", "CATEGORY");
                Integer seq = (Integer)chart.getAttribute("TICK_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("TICK_SEQ", seq);
                SimpleChartEngine.this.decodeTickLabelInfo(area, (TickLabelEntity)info, chart);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            if (model instanceof CategoryModel) {
                return ChartFactory.createBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (String)chart.getYAxis(), (CategoryDataset)SimpleChartEngine.this.CategoryModelToCategoryDataset((CategoryModel)model), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            if (model instanceof XYModel) {
                return ChartFactory.createXYBarChart((String)chart.getTitle(), (String)chart.getXAxis(), (boolean)false, (String)chart.getYAxis(), (IntervalXYDataset)((IntervalXYDataset)SimpleChartEngine.this.XYModelToXYDataset((XYModel)model)), (PlotOrientation)SimpleChartEngine.this.getOrientation(chart.getOrient()), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
            }
            throw new UiException("model must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Ring
    extends Pie {
        private Ring() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createRingChart((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Pie3d
    extends Pie {
        private Pie3d() {
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createPieChart3D((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private class Pie
    extends ChartImpl {
        private Pie() {
        }

        public void render(Chart chart, Area area, ChartEntity info) {
            if (info instanceof LegendItemEntity) {
                area.setAttribute("entity", "LEGEND");
                Integer seq = (Integer)chart.getAttribute("LEGEND_SEQ");
                seq = seq == null ? new Integer(0) : new Integer(seq + 1);
                chart.setAttribute("LEGEND_SEQ", seq);
                SimpleChartEngine.this.decodeLegendInfo(area, (LegendItemEntity)info, chart);
            } else if (info instanceof PieSectionEntity) {
                area.setAttribute("entity", "DATA");
                SimpleChartEngine.this.decodePieInfo(area, (PieSectionEntity)info);
            } else {
                area.setAttribute("entity", "TITLE");
                if (chart.isShowTooltiptext()) {
                    area.setTooltiptext(chart.getTitle());
                }
            }
        }

        protected PieDataset getDataset(ChartModel model) {
            if (model instanceof CategoryModel) {
                return SimpleChartEngine.this.CategoryModelToPieDataset((CategoryModel)model);
            }
            if (model instanceof PieModel) {
                return SimpleChartEngine.this.PieModelToPieDataset((PieModel)model);
            }
            throw new UiException("model must be a org.zkoss.zul.PieModel or a org.zkoss.zul.CategoryModel");
        }

        public JFreeChart createChart(Chart chart) {
            ChartModel model = chart.getModel();
            return ChartFactory.createPieChart((String)chart.getTitle(), (PieDataset)this.getDataset(model), (boolean)chart.isShowLegend(), (boolean)chart.isShowTooltiptext(), (boolean)true);
        }
    }

    private abstract class ChartImpl {
        private ChartImpl() {
        }

        abstract void render(Chart var1, Area var2, ChartEntity var3);

        abstract JFreeChart createChart(Chart var1);
    }
}

