/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuSelectAll;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Errorable;
import org.zkoss.zk.ui.ext.client.Inputable;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public abstract class InputElement
extends XulElement
implements Constrainted {
    private Object _value;
    private String _txtByClient;
    private String _errmsg;
    private String _name;
    private int _maxlength;
    private int _cols;
    private int _tabindex = -1;
    private Constraint _constr;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _valided;

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readOnly", this._readonly);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getErrorMessage() {
        return this._errmsg;
    }

    private void clearErrorMessage() {
        if (this._errmsg != null) {
            this._errmsg = null;
            Clients.closeErrorBox((Component)this);
        }
    }

    public String getText() throws WrongValueException {
        this.checkUserError();
        return this.coerceToString(this._value);
    }

    public void setText(String value) throws WrongValueException {
        String fmtval;
        Object val;
        try {
            if (this._maxlength > 0 && value != null && value.length() > this._maxlength) {
                throw new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._maxlength));
            }
            val = this.coerceFromString(value);
            this.validate(val);
        }
        catch (Throwable ex) {
            Throwable t;
            if (!(ex instanceof WrongValueException) && (t = Exceptions.findCause((Throwable)ex, (Class)WrongValueException.class)) != null) {
                ex = t;
            }
            if (ex instanceof WrongValueException) {
                this.smartUpdate("defaultValue", "zk_wrong!~-.zk_pha!6");
            }
            throw UiException.Aide.wrap((Throwable)ex);
        }
        this.clearErrorMessage();
        this._valided = true;
        if (!Objects.equals((Object)this._value, (Object)val)) {
            this._value = val;
            String fmtval2 = this.coerceToString(this._value);
            if (this._txtByClient == null || !Objects.equals((Object)this._txtByClient, (Object)fmtval2)) {
                this.smartUpdate("value", fmtval2);
            }
        } else if (this._txtByClient != null && !Objects.equals((Object)this._txtByClient, (Object)(fmtval = this.coerceToString(this._value)))) {
            this.smartUpdate("value", fmtval);
        }
    }

    protected abstract Object coerceFromString(String var1) throws WrongValueException;

    protected abstract String coerceToString(Object var1);

    protected void validate(Object value) throws WrongValueException {
        Constraint constr = this.getConstraint();
        if (constr != null) {
            constr.validate((Component)this, value);
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.invalidate();
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) throws WrongValueException {
        if (cols <= 0) {
            throw new WrongValueException("Illegal cols: " + cols);
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.smartUpdate("cols", Integer.toString(this._cols));
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public boolean isMultiline() {
        return false;
    }

    public String getType() {
        return "text";
    }

    public void select() {
        this.response("select", (AuResponse)new AuSelectAll((Component)this));
    }

    public void setConstraint(String constr) {
        this._constr = SimpleConstraint.getInstance(constr);
    }

    public void setConstraint(Constraint constr) {
        this._constr = constr;
    }

    public final Constraint getConstraint() {
        return this._constr;
    }

    protected boolean isAsapRequired(String evtnm) {
        return "onChange".equals(evtnm) && this._constr != null && !this._constr.isClientComplete() || super.isAsapRequired(evtnm);
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        if (this.isMultiline()) {
            if (this._cols > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"cols", (int)this._cols);
            }
            if (this._maxlength > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:maxlen", (int)this._maxlength);
            }
        } else {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)this.coerceToString(this._value));
            if (this._cols > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"size", (int)this._cols);
            }
            if (this._maxlength > 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"maxlength", (int)this._maxlength);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"type", (String)("password".equals(this.getType()) ? "password" : "text"));
        }
        if (this._tabindex >= 0) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
        if (this.isDisabled()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
        }
        if (this.isReadonly()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"readonly", (String)"readonly");
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onChange");
        this.appendAsapAttr(sb, "onChanging");
        this.appendAsapAttr(sb, "onFocus");
        this.appendAsapAttr(sb, "onBlur");
        if (this._constr != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:valid", (String)this._constr.getValidationScript());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:ermg", (String)this._constr.getErrorMessage());
            if (!this._constr.isClientComplete()) {
                sb.append(" zk_srvald=\"true\"");
            }
        }
        return sb.toString();
    }

    protected Object getRawValue() throws WrongValueException {
        this.checkUserError();
        return this._value;
    }

    public void setRawValue(Object value) {
        if (this._errmsg != null || !Objects.equals((Object)this._value, (Object)value)) {
            this.clearErrorMessage();
            this._value = value;
            this.smartUpdate("value", this.coerceToString(this._value));
        }
    }

    public boolean isValid() {
        if (this._errmsg != null) {
            return false;
        }
        if (!this._valided && this._constr != null) {
            try {
                this.validate(this._value);
            }
            catch (Throwable ex) {
                return false;
            }
        }
        return true;
    }

    protected void checkUserError() throws WrongValueException {
        if (this._errmsg != null) {
            throw new WrongValueException((Component)this, this._errmsg);
        }
        if (!this._valided && this._constr != null) {
            this.setText(this.coerceToString(this._value));
        }
    }

    public String getAreaText() {
        return XMLs.encodeText((String)this.coerceToString(this._value));
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Inputable,
    Errorable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)InputElement.this);
        }

        public void setTextByClient(String value) throws WrongValueException {
            InputElement.this._txtByClient = value;
            try {
                InputElement.this.setText(value);
            }
            catch (WrongValueException ex) {
                InputElement.this._errmsg = ex.getMessage();
                throw ex;
            }
            finally {
                InputElement.this._txtByClient = null;
            }
        }

        public void setErrorByClient(String value, String msg) {
            InputElement.this._errmsg = msg != null && msg.length() > 0 ? msg : null;
        }
    }
}

