/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.InputElement;

public abstract class FormatInputElement
extends InputElement {
    private String _format;

    public String getFormat() {
        return this._format;
    }

    public void setFormat(String format) throws WrongValueException {
        if (!Objects.equals((Object)this._format, (Object)format)) {
            String old = this._format;
            this._format = format;
            this.smartUpdate("z:fmt", this.getFormat());
            try {
                this.smartUpdate("value", this.getText());
            }
            catch (WrongValueException wrongValueException) {
                // empty catch block
            }
        }
    }

    protected String formatNumber(Object value, String defaultFormat) {
        if (value == null) {
            return "";
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locales.getCurrent());
        String fmt = this.getFormat();
        if (fmt == null) {
            fmt = defaultFormat;
        }
        if (fmt != null) {
            df.applyPattern(fmt);
        }
        return df.format(value);
    }

    protected String toNumberOnly(String val) {
        if (val == null) {
            return val;
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locales.getCurrent());
        char GROUPING = symbols.getGroupingSeparator();
        char DECIMAL = symbols.getDecimalSeparator();
        char PERCENT = symbols.getPercent();
        char MINUS = symbols.getMinusSign();
        String fmt = this.getFormat();
        StringBuffer sb = null;
        int len = val.length();
        for (int j = 0; j < len; ++j) {
            char c2;
            boolean ignore;
            char cc = val.charAt(j);
            boolean bl = ignore = (cc < '0' || cc > '9') && cc != DECIMAL && cc != MINUS && cc != '+' && cc != PERCENT && (Character.isWhitespace(cc) || cc == GROUPING || fmt != null && fmt.indexOf(cc) >= 0);
            if (ignore) {
                if (sb != null) continue;
                sb = new StringBuffer(len).append(val.substring(0, j));
                continue;
            }
            char c = cc == MINUS ? (char)'-' : (cc == DECIMAL ? (char)'.' : (c2 = cc == PERCENT ? (char)'%' : cc));
            if (cc != c2) {
                if (sb == null) {
                    sb = new StringBuffer(len).append(val.substring(0, j));
                }
                sb.append(c2);
                continue;
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        return sb != null ? sb.toString() : val;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String fmt = this.getFormat();
        return fmt != null && fmt.length() != 0 ? attrs + " z:fmt=\"" + fmt + '\"' : attrs;
    }

    protected boolean isAsapRequired(String evtnm) {
        return "onChange".equals(evtnm) && this.getFormat() != null || super.isAsapRequired(evtnm);
    }
}

