/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.impl.XulElement;

public class Treerow
extends XulElement {
    public Tree getTree() {
        Treerow p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treeitem)parent).getLevel() : 0;
    }

    public Treeitem getTreeitem() {
        return (Treeitem)this.getParent();
    }

    public String getSclass() {
        Treeitem ti;
        String scls = super.getSclass();
        if (scls == null) {
            scls = "item";
        }
        return (ti = this.getTreeitem()) != null && ti.isSelected() ? scls + "sel" : scls;
    }

    public void setContext(String context) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setPopup(String popup) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setTooltip(String tooltip) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public String getContext() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getContext() : null;
    }

    public String getPopup() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getPopup() : null;
    }

    public String getTooltip() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getTooltip() : null;
    }

    protected boolean isAsapRequired(String evtnm) {
        if (!"onOpen".equals(evtnm)) {
            return super.isAsapRequired(evtnm);
        }
        Treeitem ti = this.getTreeitem();
        return ti != null && ti.isAsapRequired(evtnm);
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        Treeitem item = this.getTreeitem();
        if (item == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        Treeitem ptitem = item.getTreeitem();
        Tree tree = this.getTree();
        if (tree != null && tree.getName() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:value", (String)Objects.toString((Object)item.getValue()));
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:item", (String)item.getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:ptitem", (String)(ptitem != null ? ptitem.getUuid() : "root"));
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z:sel", (boolean)item.isSelected());
        if (item.isContainer()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:open", (boolean)item.isOpen());
        }
        if (item.isFocusRequired()) {
            sb.append(" z:focus=\"true\"");
        }
        this.appendAsapAttr(sb, "onOpen");
        String clkattrs = item.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        return sb.toString();
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        return !((comp = comp.getParent()) instanceof Treechildren) || ((Treechildren)comp).isVisible();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Treecell)) {
            throw new UiException("Unsupported child for tree row: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }
}

