/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.RenderOnDemand;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Paging;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Listbox
extends XulElement
implements Serializable,
RenderOnDemand {
    private static final Log log;
    private transient List _items;
    private transient Set _selItems;
    private int _maxlength;
    private int _rows;
    private int _jsel = -1;
    private transient Listhead _listhead;
    private transient Listfoot _listfoot;
    private ListModel _model;
    private ListitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private String _name;
    private transient Paginal _pgi;
    private transient Paging _paging;
    private transient EventListener _pgListener;
    private boolean _multiple;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _checkmark;
    private boolean _vflex;
    private boolean _noSmartUpdate;
    private static final ListitemRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Listbox() {
        this.setSclass("listbox");
        this.init();
    }

    private void init() {
        this._items = new AbstractSequentialList(){

            public ListIterator listIterator(int index) {
                return new ItemIter(index);
            }

            public Object get(int j) {
                Object o = Listbox.this.getChildren().get(Listbox.this._listhead != null ? j + 1 : j);
                if (!(o instanceof Listitem)) {
                    throw new IndexOutOfBoundsException("Wrong index: " + j);
                }
                return o;
            }

            public int size() {
                int sz = Listbox.this.getChildren().size();
                if (Listbox.this._listhead != null) {
                    --sz;
                }
                if (Listbox.this._listfoot != null) {
                    --sz;
                }
                if (Listbox.this._paging != null) {
                    --sz;
                }
                return sz;
            }
        };
        this._selItems = new LinkedHashSet(5);
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Listbox.this.onListDataChange(event);
                }
            };
        }
    }

    public Listhead getListhead() {
        return this._listhead;
    }

    public Listfoot getListfoot() {
        return this._listfoot;
    }

    final boolean inSelectMold() {
        return "select".equals(this.getMold());
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            if (!this.inSelectMold()) {
                this.invalidate();
            }
        }
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            if (!this.inSelectMold()) {
                this.smartUpdate("z:flex", this._vflex);
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            if (this.inSelectMold()) {
                this.smartUpdate("disabled", this._disabled);
            } else {
                this.smartUpdate("z:disabled", this._disabled);
            }
        }
    }

    public final boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            if (this.inSelectMold()) {
                this.smartUpdate("readonly", this._readonly);
            } else {
                this.smartUpdate("z:readonly", this._readonly);
            }
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            if (this.inSelectMold()) {
                this.smartUpdate("size", this._rows > 0 ? Integer.toString(this._rows) : null);
            } else {
                this.smartUpdate("z:size", Integer.toString(this._rows));
                this.initAtClient();
            }
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Listitem item = this.getSelectedItem();
                this._selItems.clear();
                if (item != null) {
                    this._selItems.add(item);
                }
            }
            if (this.inSelectMold()) {
                this.smartUpdate("multiple", this._multiple);
            } else if (this.isCheckmark()) {
                this.invalidate();
            } else {
                this.smartUpdate("z:multiple", this._multiple);
            }
        }
    }

    private String getSelectedId() {
        Listitem sel = this.getSelectedItem();
        return sel != null ? sel.getUuid() : "zk_n_a";
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            if (this.inSelectMold()) {
                this.invalidate();
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            if (this.inSelectMold()) {
                this.smartUpdate("name", this._name);
            } else if (this._name != null) {
                this.smartUpdate("z:name", this._name);
            } else {
                this.invalidate();
            }
            this._name = name;
        }
    }

    public List getItems() {
        return this._items;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public Listitem getItemAtIndex(int index) {
        return (Listitem)((Object)this._items.get(index));
    }

    public int getIndexOfItem(Listitem item) {
        return item == null ? -1 : item.getIndex();
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel >= this._items.size()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this._items.size());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._multiple && this._selItems.size() > 1) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = jsel;
            Listitem item = this.getItemAtIndex(this._jsel);
            item.setSelectedDirectly(true);
            this._selItems.add(item);
            this.smartUpdate("selectedIndex", Integer.toString(this._jsel));
        }
    }

    public void selectItem(Listitem item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._multiple || !item.isSelected()) {
                this.setSelectedIndex(item.getIndex());
            }
        }
    }

    public void addItemToSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                if (item.getIndex() < this._jsel || this._jsel < 0) {
                    this._jsel = item.getIndex();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z:selId", this.getSelectedId());
                    }
                }
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", true);
                } else {
                    this.smartUpdateSelection();
                }
            }
        }
    }

    public void removeItemFromSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                int oldSel = this._jsel;
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                this.fixSelectedIndex(0);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", false);
                } else {
                    this.smartUpdateSelection();
                    if (oldSel != this._jsel) {
                        this.smartUpdate("z:selId", this.getSelectedId());
                    }
                }
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(((Listitem)((Object)it.next())).getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Listitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = -1;
            this.smartUpdate("selectedIndex", "-1");
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        if (this._items.size() != this._selItems.size()) {
            Iterator it = this._items.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            this._jsel = this._items.isEmpty() ? -1 : 0;
            this.smartUpdate("selectAll", "true");
        }
    }

    public Listitem getSelectedItem() {
        return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : null;
    }

    public void setSelectedItem(Listitem item) {
        this.selectItem(item);
    }

    public Set getSelectedItems() {
        return Collections.unmodifiableSet(this._selItems);
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public Listitem appendItem(String label, String value) {
        Listitem item = new Listitem(label, value);
        item.applyProperties();
        item.setParent((Component)this);
        return item;
    }

    public Listitem removeItemAt(int index) {
        Listitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    void initAtClient() {
        if (!this.inSelectMold() && !this.inPagingMold()) {
            this.smartUpdate("z:init", true);
        }
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        Paging paging = new Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.setTotalSize(this.getItemCount());
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public boolean isAsap() {
                    return true;
                }

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Listbox.this, evt.getPaginal(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaging() {
        if (this._model != null && this.inPagingMold()) {
            Renderer renderer = new Renderer();
            try {
                Paginal pgi = this.getPaginal();
                int pgsz = pgi.getPageSize();
                int ofs = pgi.getActivePage() * pgsz;
                ListIterator it = this.getItems().listIterator(ofs);
                while (--pgsz >= 0 && it.hasNext()) {
                    renderer.render((Listitem)((Object)it.next()));
                }
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
        this.invalidate();
    }

    public Paging getPaging() {
        return this._paging;
    }

    public int getPageSize() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi.getPageSize();
    }

    public void setPageSize(int pgsz) {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        this._pgi.setPageSize(pgsz);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public int getVisibleBegin() {
        if (!this.inPagingMold()) {
            return 0;
        }
        Paginal pgi = this.getPaginal();
        return pgi.getActivePage() * pgi.getPageSize();
    }

    public int getVisibleEnd() {
        if (!this.inPagingMold()) {
            return Integer.MAX_VALUE;
        }
        Paginal pgi = this.getPaginal();
        return (pgi.getActivePage() + 1) * pgi.getPageSize() - 1;
    }

    public void smartUpdate(String attr, String value) {
        if (!this._noSmartUpdate) {
            super.smartUpdate(attr, value);
        }
    }

    public void setPage(Page page) {
        super.setPage(page);
        if (page == null && this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this.inSelectMold()) {
            this.invalidate();
        } else if (this.inPagingMold() && child instanceof Listitem) {
            this._pgi.setTotalSize(this.getItemCount());
        }
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this.inSelectMold()) {
            this.invalidate();
        } else if (this.inPagingMold() && child instanceof Listitem) {
            this._pgi.setTotalSize(this.getItemCount());
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Listitem) {
            boolean existChild;
            if (refChild == null) {
                if (this._listfoot != null) {
                    refChild = this._listfoot;
                } else if (this._paging != null) {
                    refChild = this._paging;
                }
            } else if (refChild == this._listhead) {
                throw new UiException("Unable to insert before listhead: " + newChild);
            }
            boolean bl = existChild = newChild.getParent() == this;
            if (super.insertBefore(newChild, refChild)) {
                List children = this.getChildren();
                if (this._listhead != null && children.get(1) == newChild) {
                    this.invalidate();
                }
                Listitem childItem = (Listitem)newChild;
                int fixFrom = childItem.getIndex();
                if (refChild != null && refChild != this._listfoot && refChild != this._paging && refChild.getParent() == this) {
                    int k = ((Listitem)((Object)refChild)).getIndex();
                    if (fixFrom < 0 || k < fixFrom) {
                        fixFrom = k;
                    }
                }
                if (fixFrom < 0) {
                    childItem.setIndex(this._items.size() - 1);
                } else {
                    this.fixItemIndices(fixFrom);
                }
                int childIndex = childItem.getIndex();
                if (childItem.isSelected()) {
                    if (this._jsel < 0) {
                        this._jsel = childIndex;
                        if (!this.inSelectMold()) {
                            this.smartUpdate("z:selId", this.getSelectedId());
                        }
                        this._selItems.add(childItem);
                    } else if (this._multiple) {
                        if (this._jsel > childIndex) {
                            this._jsel = childIndex;
                            if (!this.inSelectMold()) {
                                this.smartUpdate("z:selId", this.getSelectedId());
                            }
                        }
                        this._selItems.add(childItem);
                    } else {
                        childItem.setSelectedDirectly(false);
                        childItem.invalidate();
                    }
                } else if (this._jsel >= childIndex) {
                    ++this._jsel;
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z:selId", this.getSelectedId());
                    }
                }
                this.initAtClient();
                return true;
            }
            return false;
        }
        if (newChild instanceof Listhead) {
            if (this._listhead != null && this._listhead != newChild) {
                throw new UiException("Only one listhead is allowed: " + this);
            }
            if (!this.getChildren().isEmpty()) {
                refChild = (Component)this.getChildren().get(0);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores listhead");
            }
            this.invalidate();
            this._listhead = (Listhead)newChild;
            return super.insertBefore(newChild, refChild);
        }
        if (newChild instanceof Listfoot) {
            if (this._listfoot != null && this._listfoot != newChild) {
                throw new UiException("Only one listfoot is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores listfoot");
            }
            this.invalidate();
            this._listfoot = (Listfoot)newChild;
            refChild = this._paging;
            return super.insertBefore(newChild, refChild);
        }
        if (newChild instanceof Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
            this.invalidate();
            this._paging = (Paging)newChild;
            this._pgi = this._paging;
            refChild = null;
            return super.insertBefore(newChild, refChild);
        }
        throw new UiException("Unsupported child for Listbox: " + newChild);
    }

    public boolean removeChild(Component child) {
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._listhead == child) {
            this._listhead = null;
        } else if (this._listfoot == child) {
            this._listfoot = null;
        } else {
            if (child instanceof Listitem) {
                Listitem childItem = (Listitem)child;
                int childIndex = childItem.getIndex();
                childItem.setIndex(-1);
                this.fixItemIndices(childIndex);
                if (childItem.isSelected()) {
                    this._selItems.remove((Object)childItem);
                    if (this._jsel == childIndex) {
                        this.fixSelectedIndex(childIndex);
                        if (!this.inSelectMold()) {
                            this.smartUpdate("z:selId", this.getSelectedId());
                        }
                    }
                } else if (this._jsel >= childIndex) {
                    --this._jsel;
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z:selId", this.getSelectedId());
                    }
                }
                this.initAtClient();
                return true;
            }
            if (this._paging == child) {
                this._paging = null;
                if (this._pgi == child) {
                    this._pgi = null;
                }
            }
        }
        this.invalidate();
        return true;
    }

    private void fixSelectedIndex(int j) {
        if (!this._selItems.isEmpty()) {
            ListIterator it = this._items.listIterator(j);
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                if (item.isSelected()) {
                    this._jsel = j;
                    return;
                }
                ++j;
            }
        }
        this._jsel = -1;
    }

    private void fixItemIndices(int j) {
        ListIterator it = this._items.listIterator(j);
        while (it.hasNext()) {
            ((Listitem)((Object)it.next())).setIndex(j);
            ++j;
        }
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else {
                    if (this.inSelectMold()) {
                        throw new UnsupportedOperationException("Mold select doesn't support ListModel");
                    }
                    this.smartUpdate("z:model", "true");
                }
                this.initDataListener();
                this._model = model;
                this._model.addListDataListener(this._dataListener);
            }
            this.syncModel(-1, -1);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.getItems().clear();
            this.smartUpdate("z:model", null);
        }
    }

    public ListitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ListitemRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ListitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private void syncModel(int min, int max) {
        int j;
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        if (oldsz > 0) {
            if (newsz > 0 && min < oldsz) {
                if (max < 0 || max >= oldsz) {
                    max = oldsz - 1;
                }
                if (max >= newsz) {
                    max = newsz - 1;
                }
                if (min < 0) {
                    min = 0;
                }
                ListIterator it = this._items.listIterator(min);
                while (min <= max && it.hasNext()) {
                    Listbox.clearItemAsUnloaded((Listitem)((Object)it.next()));
                    ++min;
                }
            }
            for (j = newsz; j < oldsz; ++j) {
                this.getItemAtIndex(newsz).detach();
            }
        }
        for (j = oldsz; j < newsz; ++j) {
            Listbox.newUnloadedItem().setParent((Component)this);
        }
    }

    private static Listitem newUnloadedItem() {
        Listitem item = new Listitem();
        item.applyProperties();
        item.setLoaded(false);
        Listcell cell = new Listcell();
        cell.applyProperties();
        cell.setParent((Component)item);
        return item;
    }

    private static void clearItemAsUnloaded(Listitem item) {
        List cells = item.getChildren();
        if (cells.isEmpty()) {
            Listcell cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)item);
        } else {
            Listcell listcell = (Listcell)((Object)cells.get(0));
            listcell.setLabel(null);
            listcell.setImage(null);
            int k = cells.size();
            while (--k > 0) {
                ((Component)cells.get(1)).detach();
            }
        }
        item.setLoaded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender() {
        Renderer renderer = new Renderer();
        try {
            int pgsz = this.inPagingMold() ? this._pgi.getPageSize() : this._rows;
            Iterator it = this.getItems().iterator();
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((Listitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        int min = event.getIndex0();
        int max = event.getIndex1();
        if (min < 0) {
            min = 0;
        }
        boolean done = false;
        switch (event.getType()) {
            case 1: {
                if (max < 0) {
                    max = newsz - 1;
                }
                if (max - min + 1 != newsz - oldsz) {
                    log.warning("Conflict event: number of added items not matched: " + event);
                    break;
                }
                Listitem before = min < oldsz ? this.getItemAtIndex(min) : null;
                for (int j = min; j <= max; ++j) {
                    this.insertBefore((Component)Listbox.newUnloadedItem(), (Component)before);
                }
                done = true;
                break;
            }
            case 2: {
                if (max < 0) {
                    max = oldsz - 1;
                }
                if (max - min + 1 != oldsz - newsz) {
                    log.warning("Conflict event: number of removed items not matched: " + event);
                    break;
                }
                for (int j = min; j <= max; ++j) {
                    this.getItemAtIndex(min).detach();
                }
                done = true;
            }
        }
        if (!done) {
            this.syncModel(min, max);
        }
        this.initAtClient();
    }

    private static final ListitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Listitem li) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            renderer.render(li);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                renderer.render((Listitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            if (log.debugable()) {
                log.debug("No model no render");
            }
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                renderer.render((Listitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            if (this._model != null && "select".equals(mold)) {
                throw new UnsupportedOperationException("Mold select doesn't support ListModel");
            }
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
            }
        }
    }

    public void setHeight(String height) {
        if (!Objects.equals((Object)height, (Object)this.getHeight())) {
            super.setHeight(height);
            if (!this.inSelectMold()) {
                this.initAtClient();
            }
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this.inSelectMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"size", (int)this.getRows());
            if (this.isMultiple()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"multiple", (String)"multiple");
            }
            if (this._disabled) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
            }
            if (this._readonly) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"readonly", (String)"readonly");
            }
        } else {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:name", (String)this._name);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:size", (int)this._rows);
            if (this._disabled) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:disabled", (boolean)true);
            }
            if (this._readonly) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:readonly", (boolean)true);
            }
            if (this._multiple) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:multiple", (boolean)true);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:selId", (String)this.getSelectedId());
            if (this._vflex) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:vflex", (boolean)true);
            }
            if (this._model != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:model", (boolean)true);
            }
        }
        this.appendAsapAttr(sb, "onSelect");
        return sb.toString();
    }

    public Object clone() {
        Listbox clone = (Listbox)super.clone();
        int cnt = clone._selItems.size();
        clone.init();
        if (clone._listhead != null) {
            ++cnt;
        }
        if (clone._listfoot != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Listitem) {
                Listitem li = (Listitem)((Object)child);
                if (!li.isSelected()) continue;
                this._selItems.add(li);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Listhead) {
                this._listhead = (Listhead)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Listfoot) {
                this._listfoot = (Listfoot)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Paging)) continue;
            this._paging = (Paging)child;
            this._pgi = this._paging;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Listbox.class.desiredAssertionStatus();
        log = Log.lookup((Class)Listbox.class);
        _defRend = new ListitemRenderer(){

            public void render(Listitem item, Object data) {
                item.setLabel(Objects.toString((Object)data));
                item.setValue(data);
            }
        };
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Selectable,
    ChildChangedAware,
    Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listbox.this);
        }

        public boolean isChildChangedAware() {
            return !Listbox.this.inSelectMold();
        }

        public boolean isCropper() {
            return Listbox.this.inPagingMold();
        }

        public Set getAvailableAtClient() {
            if (!Listbox.this.inPagingMold()) {
                return null;
            }
            HashSet<XulElement> avail = new HashSet<XulElement>(37);
            if (Listbox.this._listhead != null) {
                avail.add(Listbox.this._listhead);
            }
            if (Listbox.this._listfoot != null) {
                avail.add(Listbox.this._listfoot);
            }
            if (Listbox.this._paging != null) {
                avail.add(Listbox.this._paging);
            }
            Paginal pgi = Listbox.this.getPaginal();
            int pgsz = pgi.getPageSize();
            int ofs = pgi.getActivePage() * pgsz;
            ListIterator it = Listbox.this.getItems().listIterator(ofs);
            while (--pgsz >= 0 && it.hasNext()) {
                avail.add((XulElement)((Object)it.next()));
            }
            return avail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectItemsByClient(Set selItems) {
            Listbox.this._noSmartUpdate = true;
            try {
                boolean paging = Listbox.this.inPagingMold();
                if (!Listbox.this._multiple || !paging && (selItems == null || selItems.size() <= 1)) {
                    Listitem item = selItems != null && selItems.size() > 0 ? (Listitem)((Object)selItems.iterator().next()) : null;
                    Listbox.this.selectItem(item);
                } else {
                    int to;
                    int from;
                    if (paging) {
                        Paginal pgi = Listbox.this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        from = pgi.getActivePage() * pgsz;
                        to = from + pgsz;
                    } else {
                        to = 0;
                        from = 0;
                    }
                    int j = 0;
                    Iterator it = Listbox.this._items.iterator();
                    while (it.hasNext()) {
                        Listitem item = (Listitem)((Object)it.next());
                        if (selItems.contains((Object)item)) {
                            Listbox.this.addItemToSelection(item);
                        } else if (!paging) {
                            Listbox.this.removeItemFromSelection(item);
                        } else {
                            int index = item.getIndex();
                            if (index >= from && index < to) {
                                Listbox.this.removeItemFromSelection(item);
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                Listbox.this._noSmartUpdate = false;
            }
        }
    }

    private class ItemIter
    implements ListIterator,
    Serializable {
        private ListIterator _it;
        private int _j;
        private boolean _bNxt;

        private ItemIter(int index) {
            this._j = index;
        }

        public void add(Object o) {
            this.prepare();
            this._it.add(o);
            ++this._j;
        }

        public boolean hasNext() {
            return this._j < Listbox.this._items.size();
        }

        public boolean hasPrevious() {
            return this._j > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.next();
            ++this._j;
            this._bNxt = true;
            return o;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.previous();
            --this._j;
            this._bNxt = false;
            return o;
        }

        public int nextIndex() {
            return this._j;
        }

        public int previousIndex() {
            return this._j - 1;
        }

        public void remove() {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.remove();
            if (this._bNxt) {
                --this._j;
            }
        }

        public void set(Object o) {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.set(o);
        }

        private void prepare() {
            if (this._it == null) {
                int v = this._j;
                if (Listbox.this._listhead != null) {
                    ++v;
                }
                this._it = Listbox.this.getChildren().listIterator(v);
            }
        }
    }

    private class Renderer
    implements Serializable {
        private final ListitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Listbox.this._renderer != null ? Listbox.this._renderer : Listbox.getDefaultItemRenderer();
        }

        private void render(Listitem item) throws Throwable {
            if (item.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Listcell cell = (Listcell)((Object)item.getChildren().get(0));
            cell.detach();
            try {
                this._renderer.render(item, Listbox.this._model.getElementAt(item.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                item.setLoaded(true);
                throw ex;
            }
            finally {
                if (item.getChildren().isEmpty()) {
                    cell.setParent((Component)item);
                }
            }
            item.setLoaded(true);
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._rendered) {
                Listbox.this.initAtClient();
            }
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

