/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.FormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Datebox
extends FormatInputElement {
    private TimeZone _tzone;
    private boolean _lenient = true;
    private boolean _compact;

    public Datebox() {
        this.setFormat(this.getDefaultFormat());
        this.setSclass("datebox");
        this.setCols(11);
        this._compact = "zh".equals(Locales.getCurrent().getLanguage());
    }

    public Datebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    protected String getDefaultFormat() {
        String fmt;
        DateFormat df = DateFormat.getDateInstance(2, Locales.getCurrent());
        if (df instanceof SimpleDateFormat && (fmt = ((SimpleDateFormat)df).toPattern()) != null && !"M/d/yy h:mm a".equals(fmt)) {
            return fmt;
        }
        return "yyyy/MM/dd";
    }

    public boolean isLenient() {
        return this._lenient;
    }

    public void setLenient(boolean lenient) {
        if (this._lenient != lenient) {
            this._lenient = lenient;
            this.smartUpdate("z:lenient", this._lenient);
        }
    }

    public boolean isCompact() {
        return this._compact;
    }

    public void setCompact(boolean compact) {
        if (this._compact != compact) {
            this._compact = compact;
            this.invalidate();
        }
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getRawValue();
    }

    public void setValue(Date value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setFormat(String format) throws WrongValueException {
        if (format == null || format.length() == 0) {
            format = this.getDefaultFormat();
        }
        super.setFormat(format);
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getFormat();
        DateFormat df = this.getDateFormat(fmt);
        df.setLenient(this._lenient);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt});
        }
        return date;
    }

    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        if (this._lenient && !this._compact) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        if (!this._lenient) {
            sb.append(" z:lenient=\"false\"");
        }
        if (this._compact) {
            sb.append(" z:compact=\"true\"");
        }
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }
}

