/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.spring;

import org.zkoss.lang.Classes;
import org.zkoss.lang.ThreadLocals;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;

public class SpringTransactionSynchronizationListener
implements EventThreadInit,
EventThreadCleanup,
EventThreadResume {
    private static final Log log = Log.lookup((Class)SpringTransactionSynchronizationListener.class);
    private Object[] _threadLocals = null;

    public void prepare(Component comp, Event evt) {
        this.getThreadLocals();
    }

    public void init(Component comp, Event evt) {
        this.setThreadLocals();
    }

    public void cleanup(Component comp, Event evt, Throwable ex) {
        this.getThreadLocals();
    }

    public void complete(Component comp, Event evt) {
        this.setThreadLocals();
    }

    public void beforeResume(Component comp, Event evt) {
        this.getThreadLocals();
    }

    public void afterResume(Component comp, Event evt) {
        this.setThreadLocals();
    }

    public void abortResume(Component comp, Event evt) {
    }

    private void getThreadLocals() {
        try {
            Class cls = Classes.forNameByThread((String)"org.springframework.transaction.support.TransactionSynchronizationManager");
            this._threadLocals = new Object[7];
            this._threadLocals[0] = this.getThreadLocal(cls, "resources").get();
            this._threadLocals[1] = this.getThreadLocal(cls, "synchronizations").get();
            this._threadLocals[2] = this.getThreadLocal(cls, "currentTransactionName").get();
            this._threadLocals[3] = this.getThreadLocal(cls, "currentTransactionReadOnly").get();
            this._threadLocals[4] = this.getThreadLocal(cls, "actualTransactionActive").get();
            cls = Classes.forNameByThread((String)"org.springframework.orm.hibernate3.SessionFactoryUtils");
            this._threadLocals[5] = this.getThreadLocal(cls, "deferredCloseHolder").get();
            cls = Classes.forNameByThread((String)"org.springframework.transaction.interceptor.TransactionAspectSupport");
            this._threadLocals[6] = this.getThreadLocal(cls, "currentTransactionInfo").get();
        }
        catch (ClassNotFoundException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    private void setThreadLocals() {
        if (this._threadLocals != null) {
            try {
                Class cls = Classes.forNameByThread((String)"org.springframework.transaction.support.TransactionSynchronizationManager");
                this.getThreadLocal(cls, "resources").set(this._threadLocals[0]);
                this.getThreadLocal(cls, "synchronizations").set(this._threadLocals[1]);
                this.getThreadLocal(cls, "currentTransactionName").set(this._threadLocals[2]);
                this.getThreadLocal(cls, "currentTransactionReadOnly").set(this._threadLocals[3]);
                this.getThreadLocal(cls, "actualTransactionActive").set(this._threadLocals[4]);
                cls = Classes.forNameByThread((String)"org.springframework.orm.hibernate3.SessionFactoryUtils");
                this.getThreadLocal(cls, "deferredCloseHolder").set(this._threadLocals[5]);
                cls = Classes.forNameByThread((String)"org.springframework.transaction.interceptor.TransactionAspectSupport");
                this.getThreadLocal(cls, "currentTransactionInfo").set(this._threadLocals[6]);
                this._threadLocals = null;
            }
            catch (ClassNotFoundException ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    private ThreadLocal getThreadLocal(Class cls, String fldname) {
        return ThreadLocals.getThreadLocal((Class)cls, (String)fldname);
    }
}

