/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.image;

import java.awt.image.RenderedImage;
import java.io.IOException;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.image.encoder.ImageEncoder;
import org.zkoss.image.encoder.ImageEncoders;

public class Images {
    public static Image encode(String name, RenderedImage image, float quality, boolean encodeAlpha) throws IOException {
        ImageEncoder encoder = ImageEncoders.newInstance(Images.getFormat(name));
        encoder.setQuality(quality);
        encoder.setEncodingAlpha(encodeAlpha);
        return new AImage(name, encoder.encode(image));
    }

    public static Image encode(String name, RenderedImage image) throws IOException {
        ImageEncoder encoder = ImageEncoders.newInstance(Images.getFormat(name));
        return new AImage(name, encoder.encode(image));
    }

    private static String getFormat(String name) {
        int j = name.lastIndexOf(46);
        if (j < 0) {
            throw new IllegalArgumentException("Illegal name: " + name + "\nIt must contain the extension as the format, such as foo.png");
        }
        return name.substring(j + 1);
    }
}

