/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.server.AbstractStartMojo;
import org.wildfly.plugin.server.ServerType;

@Mojo(name="start-jar", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartJarMojo
extends AbstractStartMojo {
    @Parameter(property="wildfly.stdout")
    private String stdout;
    @Parameter(alias="bootable-jar-name", required=false, property="wildfly.bootable.jar.name")
    private String bootableJarName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.skip) {
            log.debug((CharSequence)"Skipping server start");
            return;
        }
        try {
            this.startServer(ServerType.STANDALONE);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    @Override
    protected CommandBuilder createCommandBuilder(Path server) throws MojoExecutionException {
        Path javaHomePath;
        BootableJarCommandBuilder commandBuilder = BootableJarCommandBuilder.of((Path)server).setJavaHome(this.javaHome);
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        if (this.debug) {
            commandBuilder.addJavaOptions(new String[]{String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%s:%d", this.debugSuspend ? "y" : "n", this.debugHost, this.debugPort)});
        }
        if (this.propertiesFile != null) {
            commandBuilder.addServerArgument("-P" + this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        Path path = javaHomePath = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        if (Environment.isModularJvm(javaHomePath)) {
            commandBuilder.addJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + commandBuilder.getJavaHome()));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        return commandBuilder;
    }

    @Override
    protected StandardOutput standardOutput() throws IOException {
        return StandardOutput.parse(this.stdout, true);
    }

    @Override
    public String goal() {
        return "start-jar";
    }

    @Override
    protected Path getServerHome() throws MojoExecutionException, MojoFailureException {
        String jarName = this.bootableJarName == null ? "server-bootable.jar" : this.bootableJarName;
        Path targetPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path jarFile = targetPath.toAbsolutePath().resolve(jarName);
        if (!Files.exists(jarFile, new LinkOption[0])) {
            throw new MojoExecutionException(String.format("Bootable JAR file '%s' doesn't exist.", jarFile));
        }
        return jarFile;
    }
}

