
export declare function escapeHtml(rawText: string): string;

export declare function format(message: string, ...args: any): string;

export declare const friendlyJSONstringify: (json: unknown) => string;

export declare function generateCodeFrame(source: string, start?: number, end?: number): string;

export declare const generateFormatCacheKey: (locale: string, key: string, source: string) => string;

export declare const getGlobalThis: () => any;

/**
 * Original Utilities
 * written by kazuya kawaguchi
 */
export declare const inBrowser: boolean;

/**
 * Useful Utilities By Evan you
 * Modified by kazuya kawaguchi
 * MIT License
 * https://github.com/vuejs/vue-next/blob/master/packages/shared/src/index.ts
 * https://github.com/vuejs/vue-next/blob/master/packages/shared/src/codeframe.ts
 */
export declare const isArray: (arg: any) => arg is any[];

export declare const isBoolean: (val: unknown) => val is boolean;

export declare const isDate: (val: unknown) => val is Date;

export declare const isEmptyObject: (val: unknown) => val is boolean;

export declare const isFunction: (val: unknown) => val is Function;

export declare const isNumber: (val: unknown) => val is number;

export declare const isObject: (val: unknown) => val is Record<any, any>;

export declare const isPlainObject: (val: unknown) => val is object;

export declare const isPromise: <T = any>(val: unknown) => val is Promise<T>;

export declare const isRegExp: (val: unknown) => val is RegExp;

export declare const isString: (val: unknown) => val is string;

export declare const isSymbol: (val: unknown) => val is symbol;

export declare const makeSymbol: (name: string) => symbol | string;

export declare let mark: (tag: string) => void | undefined;

export declare let measure: (name: string, startTag: string, endTag: string) => void | undefined;

export declare const objectToString: () => string;

export declare const toDisplayString: (val: unknown) => string;

export declare const toTypeString: (value: unknown) => string;

export declare function warn(msg: string, err?: Error): void;

export { }
