/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.test;

import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;

public class TogglzTestExecutionListener
extends AbstractTestExecutionListener {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void beforeTestMethod(TestContext testContext) {
        ApplicationContext context = testContext.getApplicationContext();
        if (context.getBeanNamesForType(FeatureManager.class).length != 1) {
            return;
        }
        FeatureManager manager = (FeatureManager)context.getBean(FeatureManager.class);
        for (Feature feature : manager.getFeatures()) {
            FeatureState state;
            FeatureState defaultFeatureState = manager.getMetaData(feature).getDefaultFeatureState();
            if (defaultFeatureState.equals((Object)(state = manager.getFeatureState(feature)))) continue;
            if (defaultFeatureState.isEnabled()) {
                state.enable();
            }
            manager.setFeatureState(state);
        }
    }
}

