/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.servlet.activation;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CIDRUtils {
    private final String cidr;
    private InetAddress inetAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;
    private final int prefixLength;

    public CIDRUtils(String cidr) throws UnknownHostException {
        this.cidr = cidr;
        if (!this.cidr.contains("/")) {
            throw new IllegalArgumentException("not an valid CIDR format!");
        }
        int index = this.cidr.indexOf("/");
        String addressPart = this.cidr.substring(0, index);
        String networkPart = this.cidr.substring(index + 1);
        this.inetAddress = InetAddress.getByName(addressPart);
        this.prefixLength = Integer.parseInt(networkPart);
        this.calculate();
    }

    private void calculate() throws UnknownHostException {
        int targetSize;
        ByteBuffer maskBuffer;
        if (this.inetAddress.getAddress().length == 4) {
            maskBuffer = ByteBuffer.allocate(4).putInt(-1);
            targetSize = 4;
        } else {
            maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
            targetSize = 16;
        }
        BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.prefixLength);
        ByteBuffer buffer = ByteBuffer.wrap(this.inetAddress.getAddress());
        BigInteger ipVal = new BigInteger(1, buffer.array());
        BigInteger startIp = ipVal.and(mask);
        BigInteger endIp = startIp.add(mask.not());
        byte[] startIpArr = this.toBytes(startIp.toByteArray(), targetSize);
        byte[] endIpArr = this.toBytes(endIp.toByteArray(), targetSize);
        this.startAddress = InetAddress.getByAddress(startIpArr);
        this.endAddress = InetAddress.getByAddress(endIpArr);
    }

    private byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    public boolean isInRange(InetAddress address) throws UnknownHostException {
        BigInteger start = new BigInteger(1, this.startAddress.getAddress());
        BigInteger end = new BigInteger(1, this.endAddress.getAddress());
        BigInteger target = new BigInteger(1, address.getAddress());
        int st = start.compareTo(target);
        int te = target.compareTo(end);
        return !(st >= 0 && st != 0 || te >= 0 && te != 0);
    }
}

