/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.web.webflux;

import java.net.URI;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.thymeleaf.spring6.web.webflux.ISpringWebFluxWebRequest;
import org.thymeleaf.util.Validate;

final class SpringWebFluxWebRequest
implements ISpringWebFluxWebRequest {
    private final ServerHttpRequest request;

    SpringWebFluxWebRequest(ServerHttpRequest request) {
        Validate.notNull((Object)request, (String)"Server HTTP Request cannot be null");
        this.request = request;
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    public String getApplicationPath() {
        return this.request.getPath().contextPath().value();
    }

    public String getPathWithinApplication() {
        return this.request.getPath().pathWithinApplication().value();
    }

    @Override
    public MultiValueMap<String, String> getHeaderMultiValueMap() {
        return this.request.getHeaders();
    }

    @Override
    public MultiValueMap<String, String> getParameterMultiValueMap() {
        return this.request.getQueryParams();
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookieMultiValueMap() {
        return this.request.getCookies();
    }

    @Override
    public Object getNativeRequestObject() {
        return this.request;
    }
}

