/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.w3c.dom.Node;

public class XpathResultMatchers {
    private final XpathExpectationsHelper xpathHelper;

    protected XpathResultMatchers(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.xpathHelper = new XpathExpectationsHelper(expression, namespaces, args);
    }

    public ResultMatcher node(final Matcher<? super Node> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNode(content, (Matcher<? super Node>)matcher);
            }
        };
    }

    public ResultMatcher exists() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.exists(content);
            }
        };
    }

    public ResultMatcher doesNotExist() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.doesNotExist(content);
            }
        };
    }

    public ResultMatcher nodeCount(final Matcher<Integer> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNodeCount(content, (Matcher<Integer>)matcher);
            }
        };
    }

    public ResultMatcher nodeCount(final int expectedCount) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNodeCount(content, expectedCount);
            }
        };
    }

    public ResultMatcher string(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertString(content, (Matcher<? super String>)matcher);
            }
        };
    }

    public ResultMatcher string(final String expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertString(content, expectedValue);
            }
        };
    }

    public ResultMatcher number(final Matcher<? super Double> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNumber(content, (Matcher<? super Double>)matcher);
            }
        };
    }

    public ResultMatcher number(final Double expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertNumber(content, expectedValue);
            }
        };
    }

    public ResultMatcher booleanValue(final Boolean value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                String content = result.getResponse().getContentAsString();
                XpathResultMatchers.this.xpathHelper.assertBoolean(content, value);
            }
        };
    }
}

