/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jose.jws;

import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;

public enum MacAlgorithm implements JwsAlgorithm
{
    HS256("HS256"),
    HS384("HS384"),
    HS512("HS512");

    private final String name;

    private MacAlgorithm(String name) {
        this.name = name;
    }

    public static MacAlgorithm from(String name) {
        for (MacAlgorithm algorithm : MacAlgorithm.values()) {
            if (!algorithm.getName().equals(name)) continue;
            return algorithm;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

