/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.backoff;

import java.util.Random;
import org.springframework.retry.RetryContext;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;

public class ExponentialRandomBackOffPolicy
extends ExponentialBackOffPolicy {
    public BackOffContext start(RetryContext context) {
        return new ExponentialRandomBackOffContext(this.getInitialInterval(), this.getMultiplier(), this.getMaxInterval());
    }

    protected ExponentialBackOffPolicy newInstance() {
        return new ExponentialRandomBackOffPolicy();
    }

    static class ExponentialRandomBackOffContext
    extends ExponentialBackOffPolicy.ExponentialBackOffContext {
        private final Random r = new Random();
        private final long initialInterval;
        private long intervalIdx;

        public ExponentialRandomBackOffContext(long expSeed, double multiplier, long maxInterval) {
            super(expSeed, multiplier, maxInterval);
            this.initialInterval = expSeed;
            this.intervalIdx = 0L;
        }

        protected synchronized long getNextInterval() {
            ++this.intervalIdx;
            return this.initialInterval + this.initialInterval * (long)Math.max(1, this.r.nextInt((int)Math.pow(this.getMultiplier(), this.intervalIdx)));
        }
    }
}

